/*
 * Decompiled with CFR 0.152.
 */
package com.github.emmowo.flags_fabric.client.generator;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector2f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class BasicOBJParser {
    private OBJSubObject currentObject = null;

    public OBJModel parse(BufferedReader reader) {
        OBJModel inst = new OBJModel(this);
        int linenumber = 0;
        try {
            String line = reader.readLine();
            while (line != null) {
                ++linenumber;
                String[] splitlines = line.split(" ");
                switch (splitlines[0]) {
                    case "o": {
                        this.currentObject = new OBJSubObject(this, splitlines[1]);
                        inst.objects.add(this.currentObject);
                        break;
                    }
                    case "v": {
                        inst.verticiesList.add(new Vector3f(Float.parseFloat(splitlines[1]), Float.parseFloat(splitlines[2]), Float.parseFloat(splitlines[3])));
                        break;
                    }
                    case "vn": {
                        inst.verticiesNormalList.add(new Vector3f(Float.parseFloat(splitlines[1]), Float.parseFloat(splitlines[2]), Float.parseFloat(splitlines[3])));
                        break;
                    }
                    case "vt": {
                        inst.verticiesTexList.add(new Vector2f(Float.parseFloat(splitlines[1]), Float.parseFloat(splitlines[2])));
                        break;
                    }
                    case "f": {
                        ArrayList<String[]> entries = new ArrayList<String[]>();
                        for (String segment : splitlines) {
                            if (Objects.equals(segment, splitlines[0])) continue;
                            entries.add(segment.split("/"));
                        }
                        OBJFace data = new OBJFace(this);
                        for (String[] entry : entries) {
                            data.verticies.add(inst.verticiesList.get(Integer.parseInt(entry[0]) - 1));
                            data.vts.add(inst.verticiesTexList.get(Integer.parseInt(entry[1]) - 1));
                            data.verticies_norm.add(inst.verticiesNormalList.get(Integer.parseInt(entry[2]) - 1));
                        }
                        this.currentObject.faces.add(data);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return inst;
    }

    @Environment(value=EnvType.CLIENT)
    public class OBJSubObject {
        public String name;
        public List<OBJFace> faces = new ArrayList<OBJFace>();
        public boolean presume_quads = true;

        public OBJSubObject(BasicOBJParser this$0, String name) {
            this.name = name;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class OBJModel {
        public List<OBJSubObject> objects = new ArrayList<OBJSubObject>();
        public List<Vector3f> verticiesList = new ArrayList<Vector3f>();
        public List<Vector3f> verticiesNormalList = new ArrayList<Vector3f>();
        public List<Vector2f> verticiesTexList = new ArrayList<Vector2f>();

        public OBJModel(BasicOBJParser this$0) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class OBJFace {
        public List<Vector3f> verticies = new ArrayList<Vector3f>();
        public List<Vector3f> verticies_norm = new ArrayList<Vector3f>();
        public List<Vector2f> vts = new ArrayList<Vector2f>();

        public OBJFace(BasicOBJParser this$0) {
        }
    }
}

