/*
 * Decompiled with CFR 0.152.
 */
package com.github.emmowo.flags_fabric.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public interface WindProvider {
    public Vector3f transformVertex(Vector3f var1);

    @Environment(value=EnvType.CLIENT)
    public static class SmallFlagWindProvider
    implements WindProvider {
        private final float seed;
        private final double time;

        public SmallFlagWindProvider(float seed, double time) {
            this.seed = seed;
            this.time = time;
        }

        @Override
        public Vector3f transformVertex(Vector3f i) {
            Vector3f v = new Vector3f((Vector3fc)i);
            v.x = v.x + (float)(Math.sin((this.time + (double)this.seed) * 0.001 + (double)v.x + Math.cos((double)(v.z + v.x) + ((double)this.seed + this.time) * 0.001)) * 0.15 * (double)v.z * (double)v.z * ((double)v.z * (class_310.method_1551().field_1687.method_8419() ? 1.2 : 1.0)));
            v.y += (float)(Math.sin((this.time + (double)this.seed) * 0.001 + (double)v.y + Math.cos((double)(v.z + v.y) + ((double)this.seed + this.time) * 0.001)) * 0.075 * (double)v.z * (double)v.z);
            return v;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FloorFlagWindProvider
    implements WindProvider {
        private final float seed;
        private final double time;

        public FloorFlagWindProvider(float seed, double time) {
            this.seed = seed;
            this.time = time;
        }

        @Override
        public Vector3f transformVertex(Vector3f i) {
            Vector3f v = new Vector3f((Vector3fc)i);
            v.x = v.x + (float)(Math.sin((this.time + (double)this.seed) * 0.001 + (double)v.x + Math.cos((double)(v.z + v.x) + ((double)this.seed + this.time) * 0.001)) * 0.225 * (double)v.z * (double)v.z * ((double)v.z * (class_310.method_1551().field_1687.method_8419() ? 1.2 : 1.0)));
            v.y += (float)(Math.sin((this.time + (double)this.seed) * 0.002 + (double)v.y + Math.cos((double)(v.z + v.y) + ((double)this.seed + this.time) * 0.001)) * 0.15 * (double)v.z * ((double)(v.z + 1.0f) * 0.5));
            return v;
        }
    }
}

