/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub;

import net.zithium.deluxehub.action.ActionManager;
import net.zithium.deluxehub.command.CommandManager;
import net.zithium.deluxehub.config.ConfigManager;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.cooldown.CooldownManager;
import net.zithium.deluxehub.hook.HooksManager;
import net.zithium.deluxehub.inventory.InventoryManager;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandException;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandPermissionsException;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandUsageException;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.MissingNestedCommandException;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.WrappedCommandException;
import net.zithium.deluxehub.libs.folialib.FoliaLib;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.metrics.bukkit.MetricsLite;
import net.zithium.deluxehub.libs.nbt.utils.MinecraftVersion;
import net.zithium.deluxehub.module.ModuleManager;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.module.modules.hologram.HologramManager;
import net.zithium.deluxehub.utility.UpdateChecker;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DeluxeHubPlugin
extends JavaPlugin {
    private static PlatformScheduler scheduler;
    private static final int BSTATS_ID = 26336;
    private ConfigManager configManager;
    private ActionManager actionManager;
    private HooksManager hooksManager;
    private CommandManager commandManager;
    private CooldownManager cooldownManager;
    private ModuleManager moduleManager;
    private InventoryManager inventoryManager;

    public static PlatformScheduler scheduler() {
        return scheduler;
    }

    @Override
    public void onEnable() {
        long start = System.currentTimeMillis();
        this.getLogger().info(" _   _            _          _    _ ");
        this.getLogger().info("| \\ |_ |  | | \\/ |_ |_| | | |_)   _)");
        this.getLogger().info("|_/ |_ |_ |_| /\\ |_ | | |_| |_)   _)");
        this.getLogger().info("");
        this.getLogger().info("Version: " + this.getDescription().getVersion());
        this.getLogger().info("Author: ItzSave & ItsLewizzz");
        this.getLogger().info("");
        if (!this.isSpigotEnvironment()) {
            this.getLogger().severe("============= SPIGOT NOT DETECTED =============");
            this.getLogger().severe("DeluxeHub requires Spigot to run.");
            this.getLogger().severe("Download it here: https://www.spigotmc.org/wiki/spigot-installation/");
            this.getLogger().severe("Plugin will now disable.");
            this.getLogger().severe("============= SPIGOT NOT DETECTED =============");
            this.getServer().getPluginManager().disablePlugin(this);
            return;
        }
        MinecraftVersion.disableUpdateCheck();
        FoliaLib foliaLib = new FoliaLib(this);
        scheduler = foliaLib.getScheduler();
        new MetricsLite(this, 26336);
        this.hooksManager = new HooksManager(this);
        this.configManager = new ConfigManager();
        this.configManager.loadFiles(this);
        if (!this.getServer().getPluginManager().isPluginEnabled(this)) {
            return;
        }
        this.commandManager = new CommandManager(this);
        this.commandManager.reload();
        this.cooldownManager = new CooldownManager();
        this.inventoryManager = new InventoryManager();
        this.inventoryManager.onEnable(this);
        this.moduleManager = new ModuleManager();
        this.moduleManager.loadModules(this);
        this.actionManager = new ActionManager(this);
        if (this.getConfigManager().getFile(ConfigType.SETTINGS).getConfig().getBoolean("update-check")) {
            new UpdateChecker(this).checkForUpdate();
        }
        this.getServer().getMessenger().registerOutgoingPluginChannel(this, "BungeeCord");
        this.getLogger().info("");
        this.getLogger().info("Successfully loaded in " + (System.currentTimeMillis() - start) + "ms");
    }

    private boolean isSpigotEnvironment() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void onDisable() {
        scheduler.cancelAllTasks();
        this.moduleManager.unloadModules();
        this.inventoryManager.onDisable();
        this.configManager.saveFiles();
    }

    public void reload() {
        scheduler.cancelAllTasks();
        HandlerList.unregisterAll(this);
        this.configManager.reloadFiles();
        this.inventoryManager.onDisable();
        this.inventoryManager.onEnable(this);
        this.getCommandManager().reload();
        this.moduleManager.loadModules(this);
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String commandLabel, String[] args) {
        try {
            this.getCommandManager().execute(cmd.getName(), args, sender);
        }
        catch (CommandPermissionsException e) {
            Messages.NO_PERMISSION.send(sender, new Object[0]);
        }
        catch (MissingNestedCommandException e) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + e.getUsage());
        }
        catch (CommandUsageException e) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + e.getUsage());
        }
        catch (WrappedCommandException e) {
            if (e.getCause() instanceof NumberFormatException) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Number expected, string received instead.");
            } else {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "An internal error has occurred. See console.");
                this.getLogger().severe("An error occurred while executing command: " + e.getMessage());
                if (e.getCause() != null) {
                    this.getLogger().severe("Caused by: " + e.getCause().getMessage());
                }
            }
        }
        catch (CommandException e) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + e.getMessage());
        }
        return true;
    }

    public HologramManager getHologramManager() {
        return (HologramManager)this.moduleManager.getModule(ModuleType.HOLOGRAMS);
    }

    public HooksManager getHookManager() {
        return this.hooksManager;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }
}

