/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.command.commands;

import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.Permissions;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.CommandContext;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.annotations.Command;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandException;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.module.modules.world.LobbySpawn;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetLobbyCommand {
    private final DeluxeHubPlugin plugin;

    public SetLobbyCommand(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"setlobby"}, desc="Set the lobby location")
    public void setlobby(CommandContext args, CommandSender sender) throws CommandException {
        if (!sender.hasPermission(Permissions.COMMAND_SET_LOBBY.getPermission())) {
            Messages.NO_PERMISSION.send(sender, new Object[0]);
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Console cannot set the spawn location.");
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getModuleManager().getDisabledWorlds().contains(player.getWorld().getName())) {
            sender.sendMessage(ColorUtil.color("&cYou cannot set the lobby location in a disabled world."));
            return;
        }
        LobbySpawn lobbyModule = (LobbySpawn)this.plugin.getModuleManager().getModule(ModuleType.LOBBY);
        lobbyModule.setLocation(player.getLocation());
        this.plugin.getConfigManager().saveFiles();
        Messages.SET_LOBBY.send(sender, new Object[0]);
    }
}

