/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.hook;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.hook.PluginHook;
import net.zithium.deluxehub.hook.hooks.head.BaseHead;
import net.zithium.deluxehub.hook.hooks.head.DatabaseHead;
import net.zithium.deluxehub.utility.PlaceholderUtil;
import org.bukkit.Bukkit;

public class HooksManager {
    private final Map<String, PluginHook> hooks = new HashMap<String, PluginHook>();

    public HooksManager(DeluxeHubPlugin plugin) {
        this.hooks.put("BASE64", new BaseHead());
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.hooks.put("PLACEHOLDER_API", null);
            PlaceholderUtil.PAPI = true;
            plugin.getLogger().info(" Hooked into PlaceholderAPI");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("HeadDatabase")) {
            this.hooks.put("HEAD_DATABASE", new DatabaseHead());
            plugin.getLogger().info(" Hooked into HeadDatabase");
        }
        this.hooks.values().stream().filter(Objects::nonNull).forEach(pluginHook -> pluginHook.onEnable(plugin));
    }

    public boolean isHookEnabled(String id) {
        return this.hooks.containsKey(id);
    }

    public PluginHook getPluginHook(String id) {
        return this.hooks.get(id);
    }
}

