/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.libs.xseries.reflection.asm;

import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.zithium.deluxehub.libs.xseries.reflection.asm.ASMVersion;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.CheckClassAdapter;

final class ASMAnalyzer {
    private static final MethodHandle CheckClassAdapter_printAnalyzerResult;

    private ASMAnalyzer() {
    }

    protected static Throwable findCause(Throwable exception, Predicate<Throwable> findCause) {
        Set circularCause = Collections.newSetFromMap(new IdentityHashMap(5));
        Throwable cause = exception;
        do {
            if (!circularCause.add(cause)) {
                return null;
            }
            if (!findCause.test(cause)) continue;
            return cause;
        } while ((cause = cause.getCause()) != null);
        return null;
    }

    protected static void verify(ClassReader classReader, ClassLoader loader, boolean printResults, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)new CheckClassAdapter(ASMVersion.LATEST_ASM_OPCODE_VERSION, (ClassVisitor)classNode, false){}, 2);
        Type syperType = classNode.superName == null ? null : Type.getObjectType((String)classNode.superName);
        List methods = classNode.methods;
        ArrayList<Type> interfaces = new ArrayList<Type>();
        for (String interfaceName : classNode.interfaces) {
            interfaces.add(Type.getObjectType((String)interfaceName));
        }
        for (MethodNode method : methods) {
            boolean hasError;
            SimpleVerifier verifier = new SimpleVerifier(Type.getObjectType((String)classNode.name), syperType, interfaces, (classNode.access & 0x200) != 0);
            Analyzer analyzer = new Analyzer((Interpreter)verifier);
            if (loader != null) {
                verifier.setClassLoader(loader);
            }
            try {
                analyzer.analyze(classNode.name, method);
                hasError = false;
            }
            catch (AnalyzerException e) {
                ClassNotFoundException cls = (ClassNotFoundException)ASMAnalyzer.findCause(e, cause -> cause instanceof ClassNotFoundException);
                if (cls == null || cls.getMessage() == null || !cls.getMessage().contains("XSeriesGen")) {
                    hasError = true;
                    e.printStackTrace(printWriter);
                }
                hasError = false;
            }
            if (!printResults && !hasError) continue;
            try {
                CheckClassAdapter_printAnalyzerResult.invokeExact(method, analyzer, printWriter);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Cannot write bytecode instructions: ", e);
            }
        }
        printWriter.flush();
    }

    static {
        MethodHandle printAnalyzerResult;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Method printer = CheckClassAdapter.class.getDeclaredMethod("printAnalyzerResult", MethodNode.class, Analyzer.class, PrintWriter.class);
            printer.setAccessible(true);
            printAnalyzerResult = lookup.unreflect(printer);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            printAnalyzerResult = null;
        }
        CheckClassAdapter_printAnalyzerResult = printAnalyzerResult;
    }
}

