/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.libs.xseries.reflection.proxy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.zithium.deluxehub.libs.xseries.reflection.proxy.ClassOverloadedMethods;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class OverloadedMethod<T> {
    public abstract T get(Supplier<String> var1);

    public abstract Collection<T> getOverloads();

    static String getParameterDescriptor(Class<?>[] parameters) {
        StringBuilder stringBuilder = new StringBuilder(parameters.length * 10);
        Class<?>[] classArray = parameters;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> parameter;
            Class<?> currentClass = parameter = classArray[i];
            while (currentClass.isArray()) {
                stringBuilder.append('[');
                currentClass = currentClass.getComponentType();
            }
            if (currentClass.isPrimitive()) {
                stringBuilder.append(OverloadedMethod.getDescriptor(currentClass));
                continue;
            }
            if (currentClass == String.class) {
                stringBuilder.append('@');
                continue;
            }
            stringBuilder.append(currentClass.getName());
        }
        return stringBuilder.toString();
    }

    static char getDescriptor(Class<?> currentClass) {
        if (currentClass == Integer.TYPE) {
            return 'I';
        }
        if (currentClass == Void.TYPE) {
            return 'V';
        }
        if (currentClass == Boolean.TYPE) {
            return 'Z';
        }
        if (currentClass == Byte.TYPE) {
            return 'B';
        }
        if (currentClass == Character.TYPE) {
            return 'C';
        }
        if (currentClass == Short.TYPE) {
            return 'S';
        }
        if (currentClass == Double.TYPE) {
            return 'D';
        }
        if (currentClass == Float.TYPE) {
            return 'F';
        }
        if (currentClass == Long.TYPE) {
            return 'J';
        }
        throw new AssertionError((Object)("Unknown primitive: " + currentClass));
    }

    private static final class Multi<T>
    extends OverloadedMethod<T> {
        private final Map<String, T> descriptorMap;

        public Multi(Map<String, T> descriptorMap) {
            this.descriptorMap = descriptorMap;
        }

        @Override
        public T get(Supplier<String> descriptor) {
            return this.descriptorMap.get(descriptor.get());
        }

        @Override
        public Collection<T> getOverloads() {
            return this.descriptorMap.values();
        }

        public String toString() {
            return "Multi(" + this.descriptorMap.keySet() + ')';
        }
    }

    private static final class Single<T>
    extends OverloadedMethod<T> {
        private final T object;

        public Single(T object) {
            this.object = object;
        }

        @Override
        public T get(Supplier<String> descriptor) {
            return this.object;
        }

        @Override
        public Collection<T> getOverloads() {
            return Collections.singleton(this.object);
        }

        public String toString() {
            return "Single";
        }
    }

    public static final class Builder<T> {
        private final Map<String, Map<String, T>> descriptorMap = new HashMap<String, Map<String, T>>(10);
        private final Function<T, String> descritporProcessor;

        public Builder(Function<T, String> descritporProcessor) {
            this.descritporProcessor = descritporProcessor;
        }

        public void add(T method, String name) {
            String descriptor;
            Map descriptors = this.descriptorMap.computeIfAbsent(name, k -> new HashMap(3));
            if (descriptors.put(descriptor = this.descritporProcessor.apply(method), method) != null) {
                throw new IllegalArgumentException("Method named '" + name + "' with descriptor '" + descriptor + "' was already added: " + descriptors);
            }
        }

        public ClassOverloadedMethods<T> build() {
            HashMap nameMapped = new HashMap(this.descriptorMap.size());
            ClassOverloadedMethods classOverloadedMethods = new ClassOverloadedMethods(nameMapped);
            this.build(nameMapped);
            return classOverloadedMethods;
        }

        public void build(Map<String, OverloadedMethod<T>> nameMapped) {
            for (Map.Entry<String, Map<String, T>> method : this.descriptorMap.entrySet()) {
                OverloadedMethod overload = method.getValue().size() == 1 ? new Single<T>(method.getValue().values().iterator().next()) : new Multi<T>(method.getValue());
                nameMapped.put(method.getKey(), overload);
            }
        }
    }
}

