/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.player;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerVanish
extends Module {
    private List<UUID> vanished;
    private final DeluxeHubPlugin plugin;
    private final PlatformScheduler scheduler;

    public PlayerVanish(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.VANISH);
        this.plugin = plugin;
        this.scheduler = DeluxeHubPlugin.scheduler();
    }

    @Override
    public void onEnable() {
        this.vanished = new CopyOnWriteArrayList<UUID>();
    }

    @Override
    public void onDisable() {
        this.vanished.clear();
    }

    public void toggleVanish(Player player) {
        if (this.isVanished(player)) {
            this.vanished.remove(player.getUniqueId());
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                this.showPlayer(player2, player);
            }
            Messages.VANISH_DISABLE.send(player, new Object[0]);
            this.scheduler.runAtEntity(player, task -> player.removePotionEffect(PotionEffectType.NIGHT_VISION));
        } else {
            this.vanished.add(player.getUniqueId());
            for (Player player3 : Bukkit.getOnlinePlayers()) {
                this.hidePlayer(player3, player);
            }
            Messages.VANISH_ENABLE.send(player, new Object[0]);
            this.scheduler.runAtEntity(player, task -> player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, -1, 0)));
        }
    }

    public boolean isVanished(Player player) {
        return this.vanished.contains(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player joiningPlayer = event.getPlayer();
        this.vanished.forEach(hiddenUUID -> {
            Player hiddenPlayer = Bukkit.getPlayer(hiddenUUID);
            if (hiddenPlayer != null) {
                this.hidePlayer(joiningPlayer, hiddenPlayer);
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.scheduler.runAtEntity(player, task -> player.removePotionEffect(PotionEffectType.NIGHT_VISION));
        this.vanished.remove(player.getUniqueId());
    }

    private void hidePlayer(Player source, Player target) {
        if (!Bukkit.isOwnedByCurrentRegion((Entity)source) || !Bukkit.isOwnedByCurrentRegion((Entity)target)) {
            return;
        }
        this.scheduler.runAtEntity(source, task -> source.hidePlayer(this.plugin, target));
    }

    private void showPlayer(Player source, Player target) {
        if (!Bukkit.isOwnedByCurrentRegion((Entity)source) || !Bukkit.isOwnedByCurrentRegion((Entity)target)) {
            return;
        }
        this.scheduler.runAtEntity(source, task -> source.showPlayer(this.plugin, target));
    }
}

