/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.visual.scoreboard;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.folialib.wrapper.task.WrappedTask;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.module.modules.visual.scoreboard.ScoreHelper;
import net.zithium.deluxehub.module.modules.visual.scoreboard.ScoreUpdateTask;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class ScoreboardManager
extends Module {
    private final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private WrappedTask scoreTask;
    private final Map<UUID, ScoreHelper> players = new ConcurrentHashMap<UUID, ScoreHelper>();
    private final Set<UUID> toggledPlayers = ConcurrentHashMap.newKeySet();
    private long joinDelay;
    private long worldDelay;
    private String title;
    private List<String> lines;

    public ScoreboardManager(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.SCOREBOARD);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.title = config.getString("scoreboard.title");
        this.lines = config.getStringList("scoreboard.lines");
        this.joinDelay = config.getLong("scoreboard.display_delay.server_enter", 1L);
        this.worldDelay = config.getLong("scoreboard.display_delay.world_change", 1L);
        if (config.getBoolean("scoreboard.refresh.enabled")) {
            this.scoreTask = this.scheduler.runTimer(new ScoreUpdateTask(this), 1L, config.getLong("scoreboard.refresh.rate"));
        }
        this.scheduler.runLater(() -> Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(this::createScoreboard), 20L);
    }

    @Override
    public void onDisable() {
        if (this.scoreTask != null) {
            this.scoreTask.cancel();
        }
        for (UUID uuid : new HashSet<UUID>(this.players.keySet())) {
            ScoreHelper helper = this.players.remove(uuid);
            if (helper == null) continue;
            helper.remove();
        }
        this.players.clear();
        this.toggledPlayers.clear();
    }

    public void createScoreboard(Player player) {
        if (this.toggledPlayers.contains(player.getUniqueId())) {
            return;
        }
        this.scheduler.runAtEntity(player, task -> {
            try {
                ScoreHelper helper = this.updateScoreboard(player.getUniqueId());
                if (helper != null) {
                    this.players.put(player.getUniqueId(), helper);
                }
            }
            catch (Exception e) {
                this.getPlugin().getLogger().warning("Failed to create scoreboard for " + player.getName());
            }
        });
    }

    public ScoreHelper updateScoreboard(UUID uuid) {
        Player player = Bukkit.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        if (this.toggledPlayers.contains(uuid)) {
            return this.players.get(uuid);
        }
        ScoreHelper helper = this.players.get(uuid);
        if (helper == null) {
            helper = new ScoreHelper(player);
        }
        helper.setTitle(this.title);
        int slot = this.lines.size();
        for (String text : this.lines) {
            helper.setSlot(slot, text);
            --slot;
        }
        return helper;
    }

    public void removeScoreboard(Player player) {
        ScoreHelper helper = this.players.remove(player.getUniqueId());
        if (helper != null) {
            this.scheduler.runAtEntity(player, task -> helper.remove());
        }
    }

    public boolean hasScore(UUID uuid) {
        return this.players.containsKey(uuid);
    }

    public Collection<UUID> getPlayers() {
        return this.players.keySet();
    }

    public void toggleScoreboard(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.toggledPlayers.contains(uuid)) {
            this.toggledPlayers.remove(uuid);
            this.createScoreboard(player);
        } else {
            this.toggledPlayers.add(uuid);
            this.removeScoreboard(player);
        }
    }

    public boolean isToggled(UUID uuid) {
        return !this.toggledPlayers.contains(uuid);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.inDisabledWorld(player.getLocation()) && !this.hasScore(player.getUniqueId())) {
            this.scheduler.runAtEntityLater((Entity)player, task -> this.createScoreboard(player), this.joinDelay);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.removeScoreboard(player);
        this.toggledPlayers.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (event.getTo().getWorld() == null) {
            return;
        }
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            return;
        }
        if (this.inDisabledWorld(event.getTo()) && this.players.containsKey(player.getUniqueId())) {
            this.removeScoreboard(player);
        } else if (!this.inDisabledWorld(event.getTo()) && !this.players.containsKey(player.getUniqueId())) {
            this.scheduler.runAtEntityLater((Entity)player, task -> this.createScoreboard(player), this.worldDelay);
        }
    }
}

