/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.world;

import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.utility.TeleportUtil;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class LobbySpawn
extends Module {
    private boolean spawnJoin;
    private Location location = null;
    private final DeluxeHubPlugin plugin;
    private final PlatformScheduler scheduler;

    public LobbySpawn(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.LOBBY);
        this.plugin = plugin;
        this.scheduler = DeluxeHubPlugin.scheduler();
    }

    @Override
    public void onEnable() {
        this.scheduler.runNextTick(task -> {
            FileConfiguration config = this.getConfig(ConfigType.DATA);
            if (config.contains("spawn")) {
                this.location = (Location)config.get("spawn");
            }
        });
        this.spawnJoin = this.getConfig(ConfigType.SETTINGS).getBoolean("join_settings.spawn_join", false);
    }

    @Override
    public void onDisable() {
        this.getConfig(ConfigType.DATA).set("spawn", this.location);
        this.plugin.getConfigManager().saveFiles();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.spawnJoin && this.location != null) {
            TeleportUtil.teleportCompat(player, this.location);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.location != null && !this.inDisabledWorld(player.getLocation())) {
            event.setRespawnLocation(this.location);
        }
    }
}

