/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.utility;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.zithium.deluxehub.libs.library.items.Base64Util;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import net.zithium.deluxehub.libs.xseries.XMaterial;
import net.zithium.deluxehub.utility.PlaceholderUtil;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class ItemStackBuilder {
    private final ItemStack ITEM_STACK;
    private static final Multimap<Attribute, AttributeModifier> EMPTY_ATTRIBUTES_MAP = MultimapBuilder.hashKeys().hashSetValues().build();

    public ItemStackBuilder(ItemStack item) {
        this.ITEM_STACK = item;
    }

    @NotNull
    public static ItemStackBuilder getItemStack(@NotNull ConfigurationSection section, Player player) {
        ItemStack item = XMaterial.matchXMaterial(section.getString("material").toUpperCase()).get().parseItem();
        if (item.getType() == Material.PLAYER_HEAD && section.contains("base64")) {
            item = Base64Util.getBaseHead(section.getString("base64")).clone();
        }
        ItemStackBuilder builder = new ItemStackBuilder(item);
        if (section.contains("amount")) {
            builder.withAmount(section.getInt("amount"));
        }
        if (section.contains("username") && player != null) {
            builder.setSkullOwner(section.getString("username").replace("%player%", player.getName()));
        }
        if (section.contains("display_name")) {
            if (player != null) {
                builder.withName(section.getString("display_name"), player);
            } else {
                builder.withName(section.getString("display_name"));
            }
        }
        if (section.contains("lore")) {
            if (player != null) {
                builder.withLore(section.getStringList("lore"), player);
            } else {
                builder.withLore(section.getStringList("lore"));
            }
        }
        if (section.contains("glow") && section.getBoolean("glow")) {
            builder.withGlow();
        }
        if (section.contains("custom_model_data")) {
            builder.withCustomModelData(section.getInt("custom_model_data"));
        }
        if (section.contains("item_flags")) {
            ArrayList flags = new ArrayList();
            section.getStringList("item_flags").forEach(text -> {
                try {
                    ItemFlag flag = ItemFlag.valueOf(text);
                    flags.add(flag);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
            builder.withFlags(flags.toArray(new ItemFlag[0]));
        }
        return builder;
    }

    @NotNull
    public static ItemStackBuilder getItemStack(ConfigurationSection section) {
        return ItemStackBuilder.getItemStack(section, null);
    }

    public ItemStackBuilder withAmount(Integer amount) {
        this.ITEM_STACK.setAmount(Optional.ofNullable(amount).orElse(1));
        return this;
    }

    public ItemStackBuilder withFlags(ItemFlag ... flags) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        if (meta != null) {
            meta.addItemFlags(flags);
            for (ItemFlag itemFlag : flags) {
                if (itemFlag != ItemFlag.HIDE_ATTRIBUTES) continue;
                meta.setAttributeModifiers(EMPTY_ATTRIBUTES_MAP);
                break;
            }
        }
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withName(String name) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.setDisplayName(ColorUtil.color(name));
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withName(String name, Player player) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.setDisplayName(ColorUtil.color(PlaceholderUtil.setPlaceholders(name, player)));
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder setSkullOwner(String owner) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        if (meta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwner(owner);
            this.ITEM_STACK.setItemMeta(skullMeta);
        }
        return this;
    }

    public ItemStackBuilder withLore(List<String> lore, Player player) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        ArrayList<String> coloredLore = new ArrayList<String>();
        for (String s : lore) {
            s = PlaceholderUtil.setPlaceholders(s, player);
            coloredLore.add(ColorUtil.color(s));
        }
        meta.setLore(coloredLore);
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withLore(List<String> lore) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        ArrayList<String> coloredLore = new ArrayList<String>();
        for (String s : lore) {
            coloredLore.add(ColorUtil.color(s));
        }
        meta.setLore(coloredLore);
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    private ItemStackBuilder withCustomModelData(int data) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.setCustomModelData(data);
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    private ItemStackBuilder withGlow() {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.addItemFlags(ItemFlag.HIDE_ENCHANTS);
        this.ITEM_STACK.setItemMeta(meta);
        this.ITEM_STACK.addUnsafeEnchantment(Enchantment.FIRE_ASPECT, 1);
        return this;
    }

    public ItemStack build() {
        return this.ITEM_STACK;
    }
}

