/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.utility.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.zithium.deluxehub.DeluxeHubPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ReflectionUtils {
    private static final JavaPlugin PLUGIN = JavaPlugin.getProvidingPlugin(DeluxeHubPlugin.class);
    public static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    public static final String CRAFTBUKKIT = "org.bukkit.craftbukkit." + VERSION + ".";
    public static final String NMS = "net.minecraft.server." + VERSION + ".";
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle SEND_PACKET;

    private ReflectionUtils() {
    }

    @Nullable
    public static Class<?> getNMSClass(@Nonnull String name) {
        try {
            return Class.forName(NMS + name);
        }
        catch (ClassNotFoundException ex) {
            PLUGIN.getLogger().log(Level.WARNING, "Could not find NMS class: " + name, ex);
            return null;
        }
    }

    @Nonnull
    public static CompletableFuture<Void> sendPacket(@Nonnull Player player, Object ... packets) {
        return CompletableFuture.runAsync(() -> ReflectionUtils.sendPacketSync(player, packets)).exceptionally(ex -> {
            PLUGIN.getLogger().log(Level.SEVERE, "Failed to send packet to player " + player.getName(), (Throwable)ex);
            return null;
        });
    }

    public static void sendPacketSync(@Nonnull Player player, Object ... packets) {
        try {
            Object handle = GET_HANDLE.invoke(player);
            Object connection = PLAYER_CONNECTION.invoke(handle);
            if (connection != null) {
                for (Object packet : packets) {
                    SEND_PACKET.invoke(connection, packet);
                }
            }
        }
        catch (Throwable throwable) {
            PLUGIN.getLogger().log(Level.SEVERE, "Failed to send packet sync to player " + player.getName(), throwable);
        }
    }

    @Nullable
    public static Object getHandle(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get handle of null player");
        try {
            return GET_HANDLE.invoke(player);
        }
        catch (Throwable throwable) {
            PLUGIN.getLogger().log(Level.SEVERE, "Failed to get handle for player " + player.getName(), throwable);
            return null;
        }
    }

    @Nullable
    public static Object getConnection(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get connection of null player");
        try {
            Object handle = GET_HANDLE.invoke(player);
            return PLAYER_CONNECTION.invoke(handle);
        }
        catch (Throwable throwable) {
            PLUGIN.getLogger().log(Level.SEVERE, "Failed to get connection for player " + player.getName(), throwable);
            return null;
        }
    }

    @Nullable
    public static Class<?> getCraftClass(@Nonnull String name) {
        try {
            return Class.forName(CRAFTBUKKIT + name);
        }
        catch (ClassNotFoundException ex) {
            PLUGIN.getLogger().log(Level.WARNING, "Could not find CraftBukkit class: " + name, ex);
            return null;
        }
    }

    static {
        Class<?> entityPlayer = ReflectionUtils.getNMSClass("EntityPlayer");
        Class<?> craftPlayer = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        Class<?> playerConnection = ReflectionUtils.getNMSClass("PlayerConnection");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle sendPacket = null;
        MethodHandle getHandle = null;
        MethodHandle connection = null;
        try {
            assert (entityPlayer != null);
            assert (playerConnection != null);
            connection = lookup.findGetter(entityPlayer, "playerConnection", playerConnection);
            getHandle = lookup.findVirtual(craftPlayer, "getHandle", MethodType.methodType(entityPlayer));
            sendPacket = lookup.findVirtual(playerConnection, "sendPacket", MethodType.methodType(Void.TYPE, ReflectionUtils.getNMSClass("Packet")));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            PLUGIN.getLogger().log(Level.SEVERE, "Failed to initialize ReflectionUtils packet handlers", ex);
        }
        PLAYER_CONNECTION = connection;
        SEND_PACKET = sendPacket;
        GET_HANDLE = getHandle;
    }
}

