/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.util;

import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class StringUtil {
    @NotNull
    public static <T extends Collection<? super String>> T copyPartialMatches(@NotNull String token, @NotNull Iterable<String> originals, @NotNull T collection) throws UnsupportedOperationException, IllegalArgumentException {
        Validate.notNull(token, "Search token cannot be null");
        Validate.notNull(collection, "Collection cannot be null");
        Validate.notNull(originals, "Originals cannot be null");
        for (String string : originals) {
            if (!StringUtil.startsWithIgnoreCase(string, token)) continue;
            collection.add((String)string);
        }
        return collection;
    }

    public static boolean startsWithIgnoreCase(@NotNull String string, @NotNull String prefix) throws IllegalArgumentException, NullPointerException {
        Validate.notNull(string, "Cannot check a null string for a match");
        if (string.length() < prefix.length()) {
            return false;
        }
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

