/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.command;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.command.CustomCommand;
import fun.lewisdev.deluxehub.command.commands.ClearchatCommand;
import fun.lewisdev.deluxehub.command.commands.DeluxeHubCommand;
import fun.lewisdev.deluxehub.command.commands.FlyCommand;
import fun.lewisdev.deluxehub.command.commands.LobbyCommand;
import fun.lewisdev.deluxehub.command.commands.LockchatCommand;
import fun.lewisdev.deluxehub.command.commands.SetLobbyCommand;
import fun.lewisdev.deluxehub.command.commands.VanishCommand;
import fun.lewisdev.deluxehub.command.commands.gamemode.AdventureCommand;
import fun.lewisdev.deluxehub.command.commands.gamemode.CreativeCommand;
import fun.lewisdev.deluxehub.command.commands.gamemode.GamemodeCommand;
import fun.lewisdev.deluxehub.command.commands.gamemode.SpectatorCommand;
import fun.lewisdev.deluxehub.command.commands.gamemode.SurvivalCommand;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.libs.command.bukkit.util.BukkitCommandsManager;
import fun.lewisdev.deluxehub.libs.command.bukkit.util.CommandsManagerRegistration;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.CommandsManager;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.injection.SimpleInjector;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private final DeluxeHubPlugin plugin;
    private final FileConfiguration config;
    private CommandsManager commands;
    private CommandsManagerRegistration commandRegistry;
    private final List<CustomCommand> customCommands;

    public CommandManager(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager().getFile(ConfigType.COMMANDS).getConfig();
        this.customCommands = new ArrayList<CustomCommand>();
    }

    public void reload() {
        if (this.commandRegistry != null) {
            this.commandRegistry.unregisterCommands();
        }
        this.commands = new BukkitCommandsManager();
        this.commandRegistry = new CommandsManagerRegistration((Plugin)this.plugin, this.commands);
        this.commands.setInjector(new SimpleInjector(this.plugin));
        this.commandRegistry.register(DeluxeHubCommand.class);
        for (String command : this.config.getConfigurationSection("commands").getKeys(false)) {
            if (!this.config.getBoolean("commands." + command + ".enabled")) continue;
            this.registerCommand(command, this.config.getStringList("commands." + command + ".aliases").toArray(new String[0]));
        }
        this.reloadCustomCommands();
    }

    public void execute(String cmd, String[] args, CommandSender sender) throws CommandException {
        this.commands.execute(cmd, args, sender, sender);
    }

    public void reloadCustomCommands() {
        if (!this.customCommands.isEmpty()) {
            this.customCommands.clear();
        }
        if (!this.config.isSet("custom_commands")) {
            return;
        }
        for (String entry : this.config.getConfigurationSection("custom_commands").getKeys(false)) {
            CustomCommand customCommand = new CustomCommand(entry, this.config.getStringList("custom_commands." + entry + ".actions"));
            if (this.config.contains("custom_commands." + entry + ".aliases")) {
                customCommand.addAliases(this.config.getStringList("custom_commands." + entry + ".aliases"));
            }
            if (this.config.contains("custom_commands." + entry + ".permission")) {
                customCommand.setPermission(this.config.getString("custom_commands." + entry + ".permission"));
            }
            this.customCommands.add(customCommand);
        }
    }

    private void registerCommand(String cmd, String[] aliases) {
        switch (cmd.toUpperCase()) {
            case "GAMEMODE": {
                this.commandRegistry.register(GamemodeCommand.class, aliases);
                break;
            }
            case "GMS": {
                this.commandRegistry.register(SurvivalCommand.class, aliases);
                break;
            }
            case "GMC": {
                this.commandRegistry.register(CreativeCommand.class, aliases);
                break;
            }
            case "GMA": {
                this.commandRegistry.register(AdventureCommand.class, aliases);
                break;
            }
            case "GMSP": {
                this.commandRegistry.register(SpectatorCommand.class, aliases);
                break;
            }
            case "CLEARCHAT": {
                this.commandRegistry.register(ClearchatCommand.class, aliases);
                break;
            }
            case "FLY": {
                this.commandRegistry.register(FlyCommand.class, aliases);
                break;
            }
            case "LOCKCHAT": {
                this.commandRegistry.register(LockchatCommand.class, aliases);
                break;
            }
            case "SETLOBBY": {
                this.commandRegistry.register(SetLobbyCommand.class, aliases);
                break;
            }
            case "LOBBY": {
                this.commandRegistry.register(LobbyCommand.class, aliases);
                break;
            }
            case "VANISH": {
                this.commandRegistry.register(VanishCommand.class, aliases);
            }
        }
    }

    public List<CustomCommand> getCustomCommands() {
        return this.customCommands;
    }
}

