/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.command.commands;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.Permissions;
import fun.lewisdev.deluxehub.config.Messages;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.CommandContext;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.annotations.Command;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlyCommand {
    public FlyCommand(DeluxeHubPlugin plugin) {
    }

    @Command(aliases={"fly"}, desc="Toggle flight mode", usage="[player]", max=1)
    public void flight(CommandContext args, CommandSender sender) throws CommandException {
        if (args.argsLength() == 0) {
            if (!(sender instanceof Player)) {
                throw new CommandException("Console cannot clear inventory");
            }
            if (!sender.hasPermission(Permissions.COMMAND_FLIGHT.getPermission())) {
                Messages.NO_PERMISSION.send(sender, new Object[0]);
                return;
            }
            Player player = (Player)sender;
            if (player.getAllowFlight()) {
                Messages.FLIGHT_DISABLE.send(player, new Object[0]);
                this.toggleFlight(player, false);
            } else {
                Messages.FLIGHT_ENABLE.send(player, new Object[0]);
                this.toggleFlight(player, true);
            }
        } else if (args.argsLength() == 1) {
            if (!sender.hasPermission(Permissions.COMMAND_FLIGHT_OTHERS.getPermission())) {
                Messages.NO_PERMISSION.send(sender, new Object[0]);
                return;
            }
            Player player = Bukkit.getPlayer(args.getString(0));
            if (player == null) {
                Messages.INVALID_PLAYER.send(sender, "%player%", args.getString(0));
                return;
            }
            if (player.getAllowFlight()) {
                Messages.FLIGHT_DISABLE.send(player, new Object[0]);
                Messages.FLIGHT_DISABLE_OTHER.send(sender, "%player%", player.getName());
                this.toggleFlight(player, false);
            } else {
                Messages.FLIGHT_ENABLE.send(player, new Object[0]);
                Messages.FLIGHT_ENABLE_OTHER.send(sender, "%player%", player.getName());
                this.toggleFlight(player, true);
            }
        }
    }

    private void toggleFlight(Player player, boolean value) {
        player.setAllowFlight(value);
        player.setFlying(value);
    }
}

