/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.inventory.inventories;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.inventory.AbstractInventory;
import fun.lewisdev.deluxehub.inventory.InventoryBuilder;
import fun.lewisdev.deluxehub.inventory.InventoryItem;
import fun.lewisdev.deluxehub.libs.library.utils.ColorUtil;
import fun.lewisdev.deluxehub.utility.ItemStackBuilder;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;

public class CustomGUI
extends AbstractInventory {
    private InventoryBuilder inventory;
    private final FileConfiguration config;

    public CustomGUI(DeluxeHubPlugin plugin, FileConfiguration config) {
        super(plugin);
        this.config = config;
    }

    @Override
    public void onEnable() {
        InventoryBuilder inventoryBuilder = new InventoryBuilder(this.config.getInt("slots"), ColorUtil.color(this.config.getString("title")));
        if (this.config.contains("refresh") && this.config.getBoolean("refresh.enabled")) {
            this.setInventoryRefresh(this.config.getLong("refresh.rate"));
        }
        for (String entry : this.config.getConfigurationSection("items").getKeys(false)) {
            try {
                ItemStackBuilder builder = ItemStackBuilder.getItemStack(this.config.getConfigurationSection("items." + entry));
                InventoryItem inventoryItem = !this.config.contains("items." + entry + ".actions") ? new InventoryItem(builder.build()) : new InventoryItem(builder.build()).addClickAction(p -> this.getPlugin().getActionManager().executeActions(p, this.config.getStringList("items." + entry + ".actions")));
                if (this.config.contains("items." + entry + ".slots")) {
                    for (String slot : this.config.getStringList("items." + entry + ".slots")) {
                        inventoryBuilder.setItem(Integer.parseInt(slot), inventoryItem);
                    }
                    continue;
                }
                if (!this.config.contains("items." + entry + ".slot")) continue;
                int slot = this.config.getInt("items." + entry + ".slot");
                if (slot == -1) {
                    while (inventoryBuilder.getInventory().firstEmpty() != -1) {
                        inventoryBuilder.setItem(inventoryBuilder.getInventory().firstEmpty(), inventoryItem);
                    }
                    continue;
                }
                inventoryBuilder.setItem(slot, inventoryItem);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getPlugin().getLogger().warning("There was an error loading GUI item ID '" + entry + "', skipping..");
            }
        }
        this.inventory = inventoryBuilder;
    }

    @Override
    protected Inventory getInventory() {
        return this.inventory.getInventory();
    }
}

