/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.libs.command.bukkit.util;

import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.CommandsManager;
import fun.lewisdev.deluxehub.libs.command.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class DynamicPluginCommand
extends Command
implements PluginIdentifiableCommand {
    protected final CommandExecutor executor;
    @Nullable
    protected final TabCompleter completer;
    protected final Object registeredWith;
    protected final Plugin owningPlugin;
    protected String[] permissions = new String[0];

    public DynamicPluginCommand(String[] aliases, String desc, String usage, CommandExecutor executor, @Nullable TabCompleter completer, Object registeredWith, Plugin plugin) {
        super(aliases[0], desc, usage, Arrays.asList(aliases));
        this.executor = executor;
        this.completer = completer;
        this.owningPlugin = plugin;
        this.registeredWith = registeredWith;
    }

    @Override
    public boolean execute(CommandSender sender, String label, String[] args) {
        return this.executor.onCommand(sender, this, label, args);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        List<String> completions;
        if (this.completer != null && (completions = this.completer.onTabComplete(sender, this, alias, args)) != null) {
            return completions;
        }
        return super.tabComplete(sender, alias, args);
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public TabCompleter getCompleter() {
        return this.completer;
    }

    public Object getRegisteredWith() {
        return this.registeredWith;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
        if (permissions != null) {
            super.setPermission(StringUtil.joinString(permissions, ";"));
        }
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    @Override
    public Plugin getPlugin() {
        return this.owningPlugin;
    }

    @Override
    public boolean testPermissionSilent(CommandSender sender) {
        if (this.permissions == null || this.permissions.length == 0) {
            return true;
        }
        if (this.registeredWith instanceof CommandsManager) {
            try {
                for (String permission : this.permissions) {
                    if (!((CommandsManager)this.registeredWith).hasPermission(sender, permission)) continue;
                    return true;
                }
                return false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.testPermissionSilent(sender);
    }
}

