/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.libs.library.shaded.xseries.base;

import fun.lewisdev.deluxehub.libs.library.shaded.xseries.XAttribute;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.XBiome;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.XEnchantment;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.XEntityType;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.XItemFlag;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.XPotion;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.XSound;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.base.XBase;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.base.XModuleMetadata;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.base.annotations.XChange;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.base.annotations.XInfo;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.base.annotations.XMerge;
import fun.lewisdev.deluxehub.libs.library.shaded.xseries.particles.XParticle;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class XRegistry<XForm extends XBase<XForm, BukkitForm>, BukkitForm>
implements Iterable<XForm> {
    @ApiStatus.Internal
    private static boolean PERFORM_AUTO_ADD = true;
    @ApiStatus.Internal
    private static boolean DISCARD_METADATA = true;
    private static final boolean KEYED_EXISTS;
    private static final Map<Class<? extends XBase<?, ?>>, XRegistry<?, ?>> REGISTRIES;
    private static boolean ensureLoaded;
    private final Map<String, XForm> nameMappings = new HashMap<String, XForm>(20);
    private final Map<BukkitForm, XForm> bukkitToX = new IdentityHashMap<BukkitForm, XForm>(20);
    private Map<XForm, XModuleMetadata> metadata;
    private Map<XForm, Field> backingFields;
    private final Class<BukkitForm> bukkitFormClass;
    private final Class<XForm> xFormClass;
    private final Supplier<Object> registrySupplier;
    private final BiFunction<BukkitForm, String[], XForm> creator;
    private final Function<Integer, XForm[]> createArray;
    private final String registryName;
    private final boolean supportsRegistry;
    private final ClassType bukkitClassType;
    private boolean pulled = false;
    private boolean alreadyDiscardedMetadata = false;

    private static void ensureLoadedRegistries() {
        if (ensureLoaded) {
            return;
        }
        XAttribute.REGISTRY.getClass();
        XSound.REGISTRY.getClass();
        XBiome.REGISTRY.getClass();
        XItemFlag.REGISTRY.getClass();
        XPotion.REGISTRY.getClass();
        XEntityType.REGISTRY.getClass();
        XEnchantment.REGISTRY.getClass();
        XParticle.REGISTRY.getClass();
        ensureLoaded = true;
    }

    @Nullable
    @ApiStatus.Experimental
    public static XRegistry<?, ?> rawRegistryOf(Class<?> clazz) {
        XRegistry.ensureLoadedRegistries();
        return REGISTRIES.get(clazz);
    }

    @Nullable
    @ApiStatus.Experimental
    public static <XForm extends XBase<XForm, BukkitForm>, BukkitForm> XRegistry<XForm, BukkitForm> registryOf(Class<? extends XForm> clazz) {
        XRegistry.ensureLoadedRegistries();
        return REGISTRIES.get(clazz);
    }

    protected static <XForm extends XBase<XForm, BukkitForm>, BukkitForm> void registerModule(XRegistry<XForm, BukkitForm> registry, Class<? extends XForm> clazz) {
        REGISTRIES.put(clazz, registry);
    }

    @ApiStatus.Internal
    public XRegistry(Class<BukkitForm> bukkitFormClass, Class<XForm> xFormClass, Supplier<Object> registrySupplier, BiFunction<BukkitForm, String[], XForm> creator, Function<Integer, XForm[]> createArray) {
        boolean supported;
        try {
            registrySupplier.get();
            supported = true;
        }
        catch (Throwable ex) {
            supported = false;
        }
        this.bukkitFormClass = Objects.requireNonNull(bukkitFormClass);
        this.xFormClass = Objects.requireNonNull(xFormClass);
        this.registryName = this.bukkitFormClass.getSimpleName();
        this.registrySupplier = registrySupplier;
        this.createArray = Objects.requireNonNull(createArray);
        this.creator = creator;
        this.supportsRegistry = supported;
        this.bukkitClassType = bukkitFormClass.isEnum() ? ClassType.ENUM : (Modifier.isAbstract(bukkitFormClass.getModifiers()) ? ClassType.ABSTRACTION : null);
        if (!this.supportsRegistry && this.bukkitClassType == null) {
            throw new IllegalStateException("Bukkit form is not an enum, abstraction or a registry " + bukkitFormClass);
        }
        XRegistry.registerModule(this, xFormClass);
    }

    @ApiStatus.Internal
    public XRegistry(Class<BukkitForm> bukkitFormClass, Class<XForm> xFormClass, Function<Integer, XForm[]> createArray) {
        this(bukkitFormClass, xFormClass, null, null, createArray);
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, XForm> nameMapping() {
        return this.nameMappings;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<BukkitForm, XForm> bukkitMapping() {
        return this.bukkitToX;
    }

    public Class<BukkitForm> getBukkitFormClass() {
        return this.bukkitFormClass;
    }

    public Class<XForm> getXFormClass() {
        return this.xFormClass;
    }

    public String getName() {
        return this.registryName;
    }

    private void pullValues() {
        if (!this.pulled) {
            this.pulled = true;
            if (this.creator == null) {
                return;
            }
            this.pullFieldNames();
            if (PERFORM_AUTO_ADD) {
                this.pullSystemValues();
            }
        }
    }

    private static <T> void processEnumLikeFields(Class<T> clazz, BiConsumer<Field, T> consumer) {
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (field.getType() != clazz || !Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                consumer.accept(field, (Field)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot process enum-like fields of: " + clazz, e);
            }
        }
    }

    @ApiStatus.Internal
    public void registerName(String name, XForm xForm) {
        this.nameMappings.put(XRegistry.normalizeName(name), xForm);
    }

    private void pullFieldNames() {
        XRegistry.processEnumLikeFields(this.xFormClass, (field, x) -> this.registerMerged((XForm)x, (Field)field));
    }

    private void pullSystemValues() {
        if (this.bukkitClassType == ClassType.ENUM) {
            for (BukkitForm bukkitForm : this.bukkitFormClass.getEnumConstants()) {
                this.std(((Enum)bukkitForm).name(), bukkitForm);
            }
        } else {
            XRegistry.processEnumLikeFields(this.bukkitFormClass, (field, bukkit) -> {
                if (bukkit == null) {
                    return;
                }
                this.std(field.getName(), bukkit);
            });
        }
        if (this.supportsRegistry) {
            for (Keyed bukkitForm : this.bukkitRegistry()) {
                this.std((XForm)bukkitForm);
            }
        }
    }

    private BukkitForm valueOf(String name) {
        name = name.toUpperCase(Locale.ENGLISH).replace('.', '_');
        Class<BukkitForm> clazz = this.bukkitFormClass;
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private BukkitForm fieldOf(String name) {
        try {
            return (BukkitForm)this.bukkitFormClass.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    @NotNull
    private Registry<?> bukkitRegistry() {
        return (Registry)this.registrySupplier.get();
    }

    @Nullable
    protected BukkitForm getBukkit(String[] names) {
        for (String name : names) {
            Object bukkitForm;
            if (this.supportsRegistry) {
                NamespacedKey key = (name = name.toLowerCase(Locale.ENGLISH)).contains(":") ? NamespacedKey.fromString((String)name) : NamespacedKey.minecraft(name);
                Object bukkit = this.bukkitRegistry().get(key);
                bukkitForm = bukkit != null ? bukkit : null;
            } else if (this.bukkitClassType == ClassType.ENUM) {
                bukkitForm = this.valueOf(name);
            } else if (this.bukkitClassType == ClassType.ABSTRACTION) {
                bukkitForm = this.fieldOf(name);
            } else {
                throw new AssertionError((Object)("None of the class strategies worked for " + this));
            }
            if (bukkitForm == null) continue;
            return bukkitForm;
        }
        return null;
    }

    @ApiStatus.Internal
    public void discardMetadata() {
        if (!DISCARD_METADATA) {
            return;
        }
        this.backingFields = null;
        this.metadata = null;
    }

    public @Unmodifiable @NotNull Collection<XForm> getValues() {
        this.pullValues();
        return Collections.unmodifiableCollection(this.bukkitToX.values());
    }

    @Deprecated
    public XForm[] values() {
        this.pullValues();
        Collection<XForm> values = this.bukkitToX.values();
        return values.toArray((XBase[])this.createArray.apply(values.size()));
    }

    @Override
    @NotNull
    public Iterator<XForm> iterator() {
        return this.getValues().iterator();
    }

    @NotNull
    public XForm getByBukkitForm(BukkitForm bukkit) {
        Objects.requireNonNull(bukkit, () -> "Cannot match null " + this.registryName);
        XBase mapping = (XBase)this.bukkitToX.get(bukkit);
        if (mapping == null) {
            if (!PERFORM_AUTO_ADD) {
                throw new UnsupportedOperationException("Unknown standard bukkit form (no auto-add) for " + this.registryName + ": " + bukkit);
            }
            if (this.creator == null) {
                throw new UnsupportedOperationException("Unsupported value for " + this.registryName + ": " + bukkit);
            }
            BukkitForm xForm = this.std((XForm)bukkit);
            if (xForm == null) {
                throw new IllegalStateException("Unknown " + this.registryName + ": " + bukkit);
            }
        }
        return (XForm)mapping;
    }

    public Optional<XForm> getByName(@NotNull String name) {
        Objects.requireNonNull(name, () -> "Cannot match null " + this.registryName);
        if (name.isEmpty()) {
            return Optional.empty();
        }
        this.pullValues();
        return Optional.ofNullable((XBase)this.nameMappings.get(XRegistry.normalizeName(name)));
    }

    @ApiStatus.Internal
    @NotNull
    public static String getBukkitName(@NotNull Object bukkitForm) {
        Objects.requireNonNull(bukkitForm, "Cannot get name of a null bukkit form");
        if (bukkitForm instanceof Enum) {
            return ((Enum)bukkitForm).name();
        }
        if (KEYED_EXISTS && bukkitForm instanceof Keyed) {
            return ((Keyed)bukkitForm).getKey().toString();
        }
        if (bukkitForm instanceof PotionEffectType) {
            return ((PotionEffectType)bukkitForm).getName();
        }
        if (bukkitForm instanceof Enchantment) {
            return ((Enchantment)bukkitForm).getName();
        }
        throw new AssertionError((Object)("Unknown xform type: " + bukkitForm + " (" + bukkitForm.getClass() + ')'));
    }

    @NotNull
    private static String format(@NotNull String name) {
        int len = name.length();
        char[] chs = new char[len];
        int count = 0;
        boolean appendUnderline = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (!(appendUnderline || count == 0 || ch != '-' && ch != ' ' && ch != '_' || chs[count] == '_')) {
                appendUnderline = true;
                continue;
            }
            boolean number = false;
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && !(number = ch >= '0' && ch <= '9')) continue;
            if (appendUnderline) {
                chs[count++] = 95;
                appendUnderline = false;
            }
            chs[count++] = number ? ch : (char)(ch & 0x5F);
        }
        return new String(chs, 0, count);
    }

    private static String normalizeName(String name) {
        if ((name = name.toLowerCase(Locale.ENGLISH)).startsWith("minecraft:")) {
            name = name.substring("minecraft:".length());
        }
        name = name.replace('.', '_');
        return name;
    }

    private XForm std(BukkitForm bukkit) {
        return this.std(null, bukkit);
    }

    private XForm std(@Nullable String extraFieldName, BukkitForm bukkit) {
        String[] stringArray;
        XBase xForm = (XBase)this.bukkitToX.get(bukkit);
        if (xForm != null) {
            return (XForm)xForm;
        }
        String name = XRegistry.getBukkitName(bukkit);
        if (this.getBukkit(new String[]{name}) == null && extraFieldName == null) {
            throw new IllegalArgumentException("Unknown standard bukkit form for " + this.registryName + ": " + bukkit + (bukkit.toString().equals(name) ? "" : " (" + name + ')'));
        }
        if (extraFieldName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = extraFieldName;
            stringArray = stringArray3;
            stringArray3[1] = name;
        }
        xForm = (XBase)this.creator.apply(bukkit, stringArray);
        if (!PERFORM_AUTO_ADD) {
            return (XForm)xForm;
        }
        this.registerName(name, xForm);
        if (extraFieldName != null) {
            this.registerName(extraFieldName, xForm);
        }
        this.bukkitToX.put(bukkit, xForm);
        return (XForm)xForm;
    }

    @ApiStatus.Internal
    public XForm std(String[] names) {
        BukkitForm bukkit = this.getBukkit(names);
        XBase xForm = (XBase)this.creator.apply(bukkit, names);
        return (XForm)this.std((XForm)xForm);
    }

    @ApiStatus.Internal
    public BukkitForm stdEnum(XForm xForm, String[] names) {
        String enumName = xForm.name();
        boolean merged = false;
        BukkitForm bukkit = this.getBukkit(new String[]{enumName});
        if (bukkit == null) {
            bukkit = this.getBukkit(names);
        }
        if (bukkit == null) {
            bukkit = this.registerMerged(xForm);
            merged = true;
        }
        return this.stdEnum0(xForm, names, bukkit, merged);
    }

    public BukkitForm stdEnum(XForm xForm, String[] names, BukkitForm bukkit) {
        return this.stdEnum0(xForm, names, bukkit, false);
    }

    @ApiStatus.Internal
    private BukkitForm stdEnum0(XForm xForm, String[] names, BukkitForm bukkit, boolean merged) {
        String enumName = xForm.name();
        if (!merged) {
            this.registerMerged(xForm);
        }
        this.registerName(enumName, xForm);
        for (String name : names) {
            this.registerName(name, xForm);
        }
        if (bukkit != null) {
            this.bukkitToX.put(bukkit, xForm);
        }
        return bukkit;
    }

    private BukkitForm registerMerged(XForm xForm) {
        return this.registerMerged(xForm, this.getBackingField(xForm));
    }

    @NotNull
    @ApiStatus.Internal
    public Field getBackingField(XForm xForm) {
        try {
            return xForm.getClass().getDeclaredField(xForm.name());
        }
        catch (NoSuchFieldException e) {
            try {
                Field field;
                if (this.backingFields == null) {
                    this.cacheBackingFields();
                }
                if ((field = this.backingFields.get(xForm)) != null) {
                    return field;
                }
            }
            catch (Throwable ex) {
                IllegalStateException newEx = new IllegalStateException("Cannot find field for XForm: " + xForm + " - " + xForm.getClass(), ex);
                newEx.addSuppressed(e);
                throw newEx;
            }
            throw new IllegalStateException("Cannot find field for XForm: " + xForm + " - " + xForm.getClass(), e);
        }
    }

    private void cacheBackingFields() {
        if (this.backingFields != null) {
            throw new IllegalStateException("Backing fields are already cached");
        }
        if (this.alreadyDiscardedMetadata) {
            throw new IllegalStateException("Metadata have already been used and discarded");
        }
        this.backingFields = new IdentityHashMap<XForm, Field>();
        this.alreadyDiscardedMetadata = true;
        for (Field field : this.xFormClass.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || field.getType() != this.xFormClass || field.isAnnotationPresent(Ignore.class)) continue;
            try {
                Object xform = Objects.requireNonNull(field.get(null), () -> "XForm backing field returned null: " + field + " for registry of " + this.xFormClass);
                XBase castForm = (XBase)xform;
                this.backingFields.put(castForm, field);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ApiStatus.Internal
    public XModuleMetadata getOrRegisterMetadata(XForm form, Field formField, boolean peekOnly) {
        XModuleMetadata meta;
        XModuleMetadata xModuleMetadata = meta = this.metadata == null ? null : this.metadata.get(form);
        if (meta != null) {
            return meta;
        }
        meta = new XModuleMetadata(formField.isAnnotationPresent(Deprecated.class), (XChange[])formField.getAnnotationsByType(XChange.class), (XMerge[])formField.getAnnotationsByType(XMerge.class), formField.getAnnotation(XInfo.class));
        if (!peekOnly) {
            if (this.metadata == null) {
                this.metadata = new IdentityHashMap<XForm, XModuleMetadata>(10);
            }
            this.metadata.put(form, meta);
        }
        return meta;
    }

    private BukkitForm registerMerged(XForm xForm, Field formField) {
        XMerge[] merges = this.getOrRegisterMetadata(xForm, formField, true).getMerges();
        Object mergedBukkit = null;
        for (XMerge merge : merges) {
            mergedBukkit = this.getBukkit(new String[]{merge.name()});
            this.registerName(merge.name(), xForm);
            if (mergedBukkit == null) continue;
            this.bukkitToX.put(mergedBukkit, xForm);
        }
        return (BukkitForm)mergedBukkit;
    }

    @ApiStatus.Internal
    public XForm std(Function<BukkitForm, XForm> xForm, String[] names) {
        BukkitForm bukkit = this.getBukkit(names);
        return (XForm)this.std((XForm)((XBase)xForm.apply(bukkit)));
    }

    @ApiStatus.Internal
    public XForm std(Function<BukkitForm, XForm> xForm, XForm tryOther, String[] names) {
        BukkitForm bukkit = this.getBukkit(names);
        if (bukkit == null) {
            bukkit = tryOther.get();
        }
        return (XForm)this.std((XForm)((XBase)xForm.apply(bukkit)));
    }

    @ApiStatus.Internal
    public XForm std(XForm xForm) {
        for (String name : xForm.getNames()) {
            this.registerName(name, xForm);
        }
        if (xForm.isSupported()) {
            this.bukkitToX.put(xForm.get(), xForm);
        }
        return xForm;
    }

    public String toString() {
        return "XRegistry<" + this.registryName + ">(nameMappings=" + this.nameMappings.size() + ", bukkitToX=" + this.bukkitToX.size() + ", bukkitFormClass=" + this.bukkitFormClass.getName() + ", xFormClass=" + this.xFormClass.getName() + ", supportsRegistry=" + this.supportsRegistry + ", bukkitFormClassType=" + (Object)((Object)this.bukkitClassType) + ", pulled=" + this.pulled + ", values=[" + this.bukkitToX.values().stream().limit(10L).map(XBase::name).collect(Collectors.joining(", ")) + ']' + ')';
    }

    static {
        boolean keyedExists = false;
        try {
            Class.forName("org.bukkit.Keyed");
            keyedExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        KEYED_EXISTS = keyedExists;
        REGISTRIES = new IdentityHashMap();
        ensureLoaded = false;
    }

    private static enum ClassType {
        ENUM,
        ABSTRACTION;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @Documented
    @ApiStatus.Internal
    public static @interface Ignore {
    }
}

