/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.hologram;

import fun.lewisdev.deluxehub.libs.library.utils.ColorUtil;
import fun.lewisdev.deluxehub.utility.reflection.ArmorStandName;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;

public class Hologram {
    private List<ArmorStand> stands;
    private Location location;
    private String name;

    public Hologram(String name, Location location) {
        this.name = name;
        this.location = location;
        this.stands = new ArrayList<ArmorStand>();
    }

    public Hologram setLines(List<String> lines) {
        this.remove();
        for (String s : lines) {
            this.addLine(s);
        }
        return this;
    }

    public Hologram addLines(List<String> lines) {
        for (String s : lines) {
            this.addLine(s);
        }
        return this;
    }

    public Hologram addLine(String text) {
        ArmorStand stand = (ArmorStand)this.location.getWorld().spawnEntity(this.location.clone().subtract(0.0, this.getHeight(), 0.0), EntityType.ARMOR_STAND);
        stand.setVisible(false);
        stand.setGravity(false);
        stand.setCustomNameVisible(true);
        stand.setCustomName(ColorUtil.color(text).trim());
        stand.setCanPickupItems(false);
        this.stands.add(stand);
        return this;
    }

    public Hologram setLine(int line, String text) {
        ArmorStand stand = this.stands.get(line - 1);
        stand.setCustomName(ColorUtil.color(text).trim());
        return this;
    }

    public Hologram removeLine(int line) {
        ArmorStand stand = this.stands.get(line - 1);
        stand.remove();
        this.stands.remove(line - 1);
        if (!this.refreshLines(line - 1)) {
            return null;
        }
        return this;
    }

    public boolean refreshLines(int line) {
        ArrayList<ArmorStand> standsTemp = new ArrayList<ArmorStand>();
        int count = 0;
        for (ArmorStand entry : this.stands) {
            if (count >= line) {
                standsTemp.add(entry);
            }
            ++count;
        }
        for (ArmorStand stand : standsTemp) {
            stand.teleport(stand.getLocation().add(0.0, 0.25, 0.0));
        }
        return count >= 1;
    }

    public Hologram setLocation(Location location) {
        this.location = location;
        this.setLines(this.stands.stream().map(ArmorStandName::getName).collect(Collectors.toList()));
        return this;
    }

    public boolean hasLine(int line) {
        return line - 1 < this.stands.size() && line > 0;
    }

    public void remove() {
        for (ArmorStand stand : this.stands) {
            stand.remove();
        }
        this.stands.clear();
    }

    public Location getLocation() {
        return this.location;
    }

    public List<ArmorStand> getStands() {
        return this.stands;
    }

    public String getName() {
        return this.name;
    }

    private double getHeight() {
        return (double)this.stands.size() * 0.25;
    }
}

