/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.hologram;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import fun.lewisdev.deluxehub.module.modules.hologram.Hologram;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class HologramManager
extends Module {
    private Set<Hologram> holograms;

    public HologramManager(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.HOLOGRAMS);
    }

    @Override
    public void onEnable() {
        this.holograms = new HashSet<Hologram>();
        this.loadHolograms();
    }

    @Override
    public void onDisable() {
        this.saveHolograms();
    }

    public void loadHolograms() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> {
            FileConfiguration config = this.getConfig(ConfigType.DATA);
            if (config.contains("holograms")) {
                for (String key : config.getConfigurationSection("holograms").getKeys(false)) {
                    List<String> lines = config.getStringList("holograms." + key + ".lines");
                    Location loc = (Location)config.get("holograms." + key + ".location");
                    if (loc == null) continue;
                    this.deleteNearbyHolograms(loc);
                    Hologram holo = this.createHologram(key, loc);
                    holo.setLines(lines);
                }
            }
        }, 40L);
    }

    public void saveHolograms() {
        FileConfiguration config = this.getConfig(ConfigType.DATA);
        this.holograms.forEach(hologram -> {
            config.set("holograms." + hologram.getName() + ".location", hologram.getLocation());
            ArrayList<String> lines = new ArrayList<String>();
            for (ArmorStand stand : hologram.getStands()) {
                lines.add(stand.getCustomName());
            }
            config.set("holograms." + hologram.getName() + ".lines", lines);
        });
        this.getPlugin().getConfigManager().getFile(ConfigType.DATA).save();
        this.deleteAllHolograms();
    }

    public Set<Hologram> getHolograms() {
        return this.holograms;
    }

    public boolean hasHologram(String name) {
        return this.getHolograms().stream().anyMatch(hologram -> hologram.getName().equalsIgnoreCase(name));
    }

    public Hologram getHologram(String name) {
        return this.getHolograms().stream().filter(hologram -> hologram.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Hologram createHologram(String name, Location location) {
        Hologram holo = new Hologram(name, location);
        this.holograms.add(holo);
        return holo;
    }

    public void deleteHologram(String name) {
        Hologram holo = this.getHologram(name);
        holo.remove();
        this.holograms.remove(holo);
        this.getConfig(ConfigType.DATA).set("holograms." + name, null);
        this.getPlugin().getConfigManager().getFile(ConfigType.DATA).save();
    }

    public void deleteAllHolograms() {
        this.holograms.forEach(Hologram::remove);
        this.holograms.clear();
    }

    public void deleteNearbyHolograms(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.getNearbyEntities(location, 0.5, 20.0, 0.5).stream().filter(entity -> entity instanceof ArmorStand).forEach(Entity::remove);
    }
}

