/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.hotbar;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.libs.nbt.NBTItem;
import fun.lewisdev.deluxehub.libs.xseries.XMaterial;
import fun.lewisdev.deluxehub.module.modules.hotbar.HotbarManager;
import fun.lewisdev.deluxehub.utility.ItemStackBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public abstract class HotbarItem
implements Listener {
    private final HotbarManager hotbarManager;
    private final ItemStack item;
    private ConfigurationSection configurationSection;
    private final String key;
    private String permission = null;
    private final int slot;
    private boolean allowMovement;

    public HotbarItem(HotbarManager hotbarManager, ItemStack item, int slot, String key) {
        this.hotbarManager = hotbarManager;
        this.key = key;
        this.slot = slot;
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.setString("hotbarItem", key);
        this.item = nbtItem.getItem();
    }

    public DeluxeHubPlugin getPlugin() {
        return this.hotbarManager.getPlugin();
    }

    public HotbarManager getHotbarManager() {
        return this.hotbarManager;
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected abstract void onInteract(Player var1);

    public String getKey() {
        return this.key;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setAllowMovement(boolean allowMovement) {
        this.allowMovement = allowMovement;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setConfigurationSection(ConfigurationSection configurationSection) {
        this.configurationSection = configurationSection;
    }

    public ConfigurationSection getConfigurationSection() {
        return this.configurationSection;
    }

    public void giveItem(Player player) {
        if (this.permission != null && !player.hasPermission(this.permission)) {
            return;
        }
        ItemStack newItem = this.item.clone();
        if (this.getConfigurationSection() != null && this.getConfigurationSection().contains("username")) {
            newItem = new ItemStackBuilder(newItem).setSkullOwner(player.getName()).build();
        }
        player.getInventory().setItem(this.slot, newItem);
    }

    public void removeItem(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack item = inventory.getItem(this.slot);
        if (item != null && new NBTItem(item).getString("hotbarItem").equals(this.key)) {
            inventory.remove(inventory.getItem(this.slot));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.allowMovement) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (event.getSlot() == this.slot && new NBTItem(clicked).getString("hotbarItem").equals(this.key)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void hotbarItemInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (XMaterial.supports(9) && event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getItemInHand();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            return;
        }
        if (item.getType() == Material.AIR) {
            return;
        }
        if (!new NBTItem(item).getString("hotbarItem").equals(this.key)) {
            return;
        }
        this.onInteract(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void hotbarPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            this.giveItem(player);
        }
    }

    @EventHandler
    public void hotbarPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            this.removeItem(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void hotbarWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> {
            if (this.getHotbarManager().inDisabledWorld(player.getLocation())) {
                this.removeItem(player);
            } else {
                this.giveItem(player);
            }
        }, 5L);
    }

    @EventHandler
    public void hotbarPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!this.getHotbarManager().inDisabledWorld(player.getLocation())) {
            this.giveItem(player);
        }
    }
}

