/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.visual.scoreboard;

import fun.lewisdev.deluxehub.libs.library.utils.ColorUtil;
import fun.lewisdev.deluxehub.utility.PlaceholderUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreHelper {
    private final Scoreboard scoreboard;
    private final Objective objective;
    private final Player player;

    public ScoreHelper(Player player) {
        this.player = player;
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.objective = this.scoreboard.registerNewObjective("sidebar", "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        for (int i = 1; i <= 15; ++i) {
            Team team = this.scoreboard.registerNewTeam("SLOT_" + i);
            team.addEntry(this.genEntry(i));
        }
        player.setScoreboard(this.scoreboard);
    }

    public void setTitle(String title) {
        this.objective.setDisplayName((title = this.setPlaceholders(title)).length() > 32 ? title.substring(0, 32) : title);
    }

    public void setSlot(int slot, String text) {
        Team team = this.scoreboard.getTeam("SLOT_" + slot);
        String entry = this.genEntry(slot);
        if (!this.scoreboard.getEntries().contains(entry)) {
            this.objective.getScore(entry).setScore(slot);
        }
        text = this.setPlaceholders(text);
        String pre = this.getFirstSplit(text);
        String suf = this.getFirstSplit(ChatColor.getLastColors(pre) + this.getSecondSplit(text));
        team.setPrefix(pre);
        team.setSuffix(suf);
    }

    public void removeSlot(int slot) {
        String entry = this.genEntry(slot);
        if (this.scoreboard.getEntries().contains(entry)) {
            this.scoreboard.resetScores(entry);
        }
    }

    public String setPlaceholders(String text) {
        return ColorUtil.color(PlaceholderUtil.setPlaceholders(text, this.player));
    }

    public void setSlotsFromList(List<String> list) {
        while (list.size() > 15) {
            list.remove(list.size() - 1);
        }
        int slot = list.size();
        if (slot < 15) {
            for (int i = slot + 1; i <= 15; ++i) {
                this.removeSlot(i);
            }
        }
        for (String line : list) {
            this.setSlot(slot, line);
            --slot;
        }
    }

    private String genEntry(int slot) {
        return ChatColor.values()[slot].toString();
    }

    private String getFirstSplit(String s) {
        return s.length() > 16 ? s.substring(0, 16) : s;
    }

    private String getSecondSplit(String s) {
        if (s.length() > 32) {
            s = s.substring(0, 32);
        }
        return s.length() > 16 ? s.substring(16) : "";
    }
}

