/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.visual.tablist;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import fun.lewisdev.deluxehub.module.modules.visual.tablist.TablistHelper;
import fun.lewisdev.deluxehub.module.modules.visual.tablist.TablistUpdateTask;
import fun.lewisdev.deluxehub.utility.PlaceholderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TablistManager
extends Module {
    private List<UUID> players;
    private int tablistTask;
    private String header;
    private String footer;

    public TablistManager(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.TABLIST);
    }

    @Override
    public void onEnable() {
        this.players = new ArrayList<UUID>();
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.header = config.getStringList("tablist.header").stream().collect(Collectors.joining("\n"));
        this.footer = config.getStringList("tablist.footer").stream().collect(Collectors.joining("\n"));
        if (config.getBoolean("tablist.refresh.enabled")) {
            this.tablistTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), new TablistUpdateTask(this), 0L, config.getLong("tablist.refresh.rate"));
        }
        this.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(this::createTablist), 20L);
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.tablistTask);
        Bukkit.getOnlinePlayers().forEach(this::removeTablist);
    }

    public void createTablist(Player player) {
        UUID uuid = player.getUniqueId();
        this.players.add(uuid);
        this.updateTablist(uuid);
    }

    public boolean updateTablist(UUID uuid) {
        if (!this.players.contains(uuid)) {
            return false;
        }
        Player player = Bukkit.getPlayer(uuid);
        if (player == null) {
            return false;
        }
        TablistHelper.sendTabList(player, PlaceholderUtil.setPlaceholders(this.header, player), PlaceholderUtil.setPlaceholders(this.footer, player));
        return true;
    }

    public void removeTablist(Player player) {
        if (this.players.contains(player.getUniqueId())) {
            this.players.remove(player.getUniqueId());
            TablistHelper.sendTabList(player, null, null);
        }
    }

    public List<UUID> getPlayers() {
        return this.players;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.inDisabledWorld(player.getLocation())) {
            this.createTablist(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeTablist(event.getPlayer());
    }

    @EventHandler
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().getWorld().getName().equals(event.getTo().getWorld().getName())) {
            return;
        }
        if (this.inDisabledWorld(event.getTo().getWorld()) && this.players.contains(player.getUniqueId())) {
            this.removeTablist(player);
        } else {
            this.createTablist(player);
        }
    }
}

