/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.world;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.Permissions;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.config.Messages;
import fun.lewisdev.deluxehub.libs.xseries.XMaterial;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class AntiWorldDownloader
extends Module
implements PluginMessageListener {
    private final boolean legacy = !XMaterial.supports(13);

    public AntiWorldDownloader(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.ANTI_WDL);
    }

    @Override
    public void onEnable() {
        if (this.legacy) {
            this.getPlugin().getServer().getMessenger().registerIncomingPluginChannel(this.getPlugin(), "WDL|INIT", this);
            this.getPlugin().getServer().getMessenger().registerOutgoingPluginChannel(this.getPlugin(), "WDL|CONTROL");
        } else {
            this.getPlugin().getServer().getMessenger().registerIncomingPluginChannel(this.getPlugin(), "wdl:init", this);
            this.getPlugin().getServer().getMessenger().registerOutgoingPluginChannel(this.getPlugin(), "wdl:control");
        }
    }

    @Override
    public void onDisable() {
        if (this.legacy) {
            this.getPlugin().getServer().getMessenger().unregisterIncomingPluginChannel(this.getPlugin(), "WDL|INIT");
            this.getPlugin().getServer().getMessenger().unregisterOutgoingPluginChannel(this.getPlugin(), "WDL|CONTROL");
        } else {
            this.getPlugin().getServer().getMessenger().unregisterIncomingPluginChannel(this.getPlugin(), "wdl:init");
            this.getPlugin().getServer().getMessenger().unregisterOutgoingPluginChannel(this.getPlugin(), "wdl:control");
        }
    }

    @Override
    public void onPluginMessageReceived(String channel, Player player, byte[] data) {
        if (player.hasPermission(Permissions.ANTI_WDL_BYPASS.getPermission())) {
            return;
        }
        if (this.legacy && channel.equals("WDL|INIT") || !this.legacy && channel.equals("wdl:init")) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeInt(0);
            out.writeBoolean(false);
            if (this.legacy) {
                player.sendPluginMessage(this.getPlugin(), "WDL|CONTROL", out.toByteArray());
            } else {
                player.sendPluginMessage(this.getPlugin(), "wdl:control", out.toByteArray());
            }
            if (!this.getPlugin().getConfigManager().getFile(ConfigType.SETTINGS).getConfig().getBoolean("anti_wdl.admin_notify")) {
                return;
            }
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (!player2.hasPermission(Permissions.ANTI_WDL_NOTIFY.getPermission())) continue;
                Messages.WORLD_DOWNLOAD_NOTIFY.send(player2, "%player%", player.getName());
            }
        }
    }
}

