/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.action.Action;
import net.zithium.deluxehub.action.actions.ActionbarAction;
import net.zithium.deluxehub.action.actions.BroadcastMessageAction;
import net.zithium.deluxehub.action.actions.BungeeAction;
import net.zithium.deluxehub.action.actions.CloseInventoryAction;
import net.zithium.deluxehub.action.actions.CommandAction;
import net.zithium.deluxehub.action.actions.ConsoleCommandAction;
import net.zithium.deluxehub.action.actions.GamemodeAction;
import net.zithium.deluxehub.action.actions.MenuAction;
import net.zithium.deluxehub.action.actions.MessageAction;
import net.zithium.deluxehub.action.actions.PotionEffectAction;
import net.zithium.deluxehub.action.actions.ProxyAction;
import net.zithium.deluxehub.action.actions.SoundAction;
import net.zithium.deluxehub.action.actions.TitleAction;
import net.zithium.deluxehub.utility.PlaceholderUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class ActionManager {
    private final DeluxeHubPlugin plugin;
    private final Map<String, Action> actions;

    public ActionManager(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
        this.actions = new HashMap<String, Action>();
        this.load();
    }

    private void load() {
        this.registerAction(new MessageAction(), new BroadcastMessageAction(), new CommandAction(), new ConsoleCommandAction(), new SoundAction(), new PotionEffectAction(), new GamemodeAction(), new BungeeAction(), new CloseInventoryAction(), new ActionbarAction(), new TitleAction(), new MenuAction(), new ProxyAction());
    }

    public void registerAction(Action ... actions) {
        Arrays.asList(actions).forEach(action -> this.actions.put(action.getIdentifier(), (Action)action));
    }

    public void executeActions(Player player, List<String> items) {
        items.forEach(item -> {
            Action action;
            String actionName = StringUtils.substringBetween(item, "[", "]");
            Action action2 = action = actionName == null ? null : this.actions.get(actionName.toUpperCase());
            if (action != null) {
                item = item.contains(" ") ? item.split(" ", 2)[1] : "";
                item = PlaceholderUtil.setPlaceholders(item, player);
                action.execute(this.plugin, player, (String)item);
            } else {
                this.plugin.getLogger().warning("There was a problem attempting to process action: '" + item + "'");
            }
        });
    }
}

