/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.command.commands.gamemode;

import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.Permissions;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.CommandContext;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.annotations.Command;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandException;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpectatorCommand {
    public SpectatorCommand(DeluxeHubPlugin plugin) {
    }

    @Command(aliases={"gmsp"}, desc="Change to spectator mode", usage="[player]", max=1)
    public void spectator(CommandContext args, CommandSender sender) throws CommandException {
        if (args.argsLength() == 0) {
            if (!(sender instanceof Player)) {
                throw new CommandException("Console cannot change gamemode");
            }
            Player player = (Player)sender;
            if (!player.hasPermission(Permissions.COMMAND_GAMEMODE.getPermission())) {
                Messages.NO_PERMISSION.send(sender, new Object[0]);
                return;
            }
            Messages.GAMEMODE_CHANGE.send(player, "%gamemode%", "SPECTATOR");
            player.setGameMode(GameMode.SPECTATOR);
        } else if (args.argsLength() == 1) {
            if (!sender.hasPermission(Permissions.COMMAND_GAMEMODE_OTHERS.getPermission())) {
                Messages.NO_PERMISSION.send(sender, new Object[0]);
                return;
            }
            Player player = Bukkit.getPlayer(args.getString(0));
            if (player == null) {
                Messages.INVALID_PLAYER.send(sender, "%player%", args.getString(0));
                return;
            }
            if (sender.getName().equals(player.getName())) {
                Messages.GAMEMODE_CHANGE.send(player, "%gamemode%", "SPECTATOR");
            } else {
                Messages.GAMEMODE_CHANGE.send(player, "%gamemode%", "SPECTATOR");
                Messages.GAMEMODE_CHANGE_OTHER.send(sender, "%player%", player.getName(), "%gamemode%", "SPECTATOR");
            }
            player.setGameMode(GameMode.SPECTATOR);
        }
    }
}

