/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigHandler;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.config.Messages;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final Map<ConfigType, ConfigHandler> configurations = new HashMap<ConfigType, ConfigHandler>();

    public void loadFiles(DeluxeHubPlugin plugin) {
        this.registerFile(ConfigType.SETTINGS, new ConfigHandler(plugin, "config"));
        this.registerFile(ConfigType.MESSAGES, new ConfigHandler(plugin, "messages"));
        this.registerFile(ConfigType.DATA, new ConfigHandler(plugin, "data"));
        this.registerFile(ConfigType.COMMANDS, new ConfigHandler(plugin, "commands"));
        this.configurations.values().forEach(ConfigHandler::saveDefaultConfig);
        Messages.setConfiguration(this.getFile(ConfigType.MESSAGES).getConfig());
    }

    public ConfigHandler getFile(ConfigType type) {
        return this.configurations.get((Object)type);
    }

    public void reloadFiles() {
        this.configurations.values().forEach(ConfigHandler::reload);
        Messages.setConfiguration(this.getFile(ConfigType.MESSAGES).getConfig());
    }

    public void saveFiles() {
        this.getFile(ConfigType.DATA).save();
    }

    public void registerFile(ConfigType type, ConfigHandler config) {
        this.configurations.put(type, config);
    }

    public FileConfiguration getFileConfiguration(File file) {
        return YamlConfiguration.loadConfiguration(file);
    }
}

