/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.hook.hooks.head;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.hook.PluginHook;
import net.zithium.deluxehub.hook.hooks.head.HeadHook;
import net.zithium.deluxehub.libs.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class BaseHead
implements PluginHook,
HeadHook {
    private Map<String, ItemStack> cache;
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    @Override
    public void onEnable(DeluxeHubPlugin plugin) {
        this.cache = new HashMap<String, ItemStack>();
    }

    @Override
    public ItemStack getHead(String data) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        BaseHead.setBase64ToSkullMeta(data, meta);
        head.setItemMeta(meta);
        return head;
    }

    private static PlayerProfile getProfileBase64(String base64) {
        URL urlObject;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = BaseHead.getUrlFromBase64(base64);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }

    private static URL getUrlFromBase64(String base64) throws MalformedURLException, URISyntaxException {
        String decoded = new String(Base64.getDecoder().decode(base64));
        String urlString = decoded.substring("{\"textures\":{\"SKIN\":{\"url\":\"".length(), decoded.length() - "\"}}}".length());
        return new URI(urlString).toURL();
    }

    private static void setBase64ToSkullMeta(String base64, SkullMeta meta) {
        meta.setOwnerProfile(BaseHead.getProfileBase64(base64));
    }
}

