/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.inventory.InventoryBuilder;
import net.zithium.deluxehub.inventory.InventoryTask;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.utility.ItemStackBuilder;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractInventory
implements Listener {
    private final DeluxeHubPlugin plugin;
    private final PlatformScheduler scheduler;
    private boolean refreshEnabled = false;
    private final List<UUID> openInventories;

    public AbstractInventory(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
        this.scheduler = DeluxeHubPlugin.scheduler();
        this.openInventories = new ArrayList<UUID>();
        plugin.getServer().getPluginManager().registerEvents(this, plugin);
    }

    public void setInventoryRefresh(long value) {
        if (value <= 0L) {
            return;
        }
        this.scheduler.runTimerAsync(new InventoryTask(this), 1L, value);
        this.refreshEnabled = true;
    }

    public abstract void onEnable();

    protected abstract Inventory getInventory();

    protected DeluxeHubPlugin getPlugin() {
        return this.plugin;
    }

    public Inventory refreshInventory(Player player, Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = this.getInventory().getItem(i);
            if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) continue;
            ItemStackBuilder newItem = new ItemStackBuilder(item.clone());
            if (item.getItemMeta().hasDisplayName()) {
                newItem.withName(item.getItemMeta().getDisplayName(), player);
            }
            if (item.getItemMeta().hasLore()) {
                newItem.withLore(item.getItemMeta().getLore(), player);
            }
            inventory.setItem(i, newItem.build());
        }
        return inventory;
    }

    public void openInventory(Player player) {
        if (this.getInventory() == null) {
            return;
        }
        this.scheduler.runAtEntity(player, task -> player.openInventory(this.refreshInventory(player, this.getInventory())));
        if (this.refreshEnabled && !this.openInventories.contains(player.getUniqueId())) {
            this.openInventories.add(player.getUniqueId());
        }
    }

    public List<UUID> getOpenInventories() {
        return this.openInventories;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTopInventory().getHolder() instanceof InventoryBuilder && this.refreshEnabled) {
            this.openInventories.remove(event.getPlayer().getUniqueId());
        }
    }
}

