/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.inventory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.inventory.AbstractInventory;
import net.zithium.deluxehub.inventory.InventoryListener;
import net.zithium.deluxehub.inventory.inventories.CustomGUI;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class InventoryManager {
    private DeluxeHubPlugin plugin;
    private PlatformScheduler scheduler;
    private final Map<String, AbstractInventory> inventories = new ConcurrentHashMap<String, AbstractInventory>();

    public void onEnable(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
        this.scheduler = DeluxeHubPlugin.scheduler();
        this.loadCustomMenus();
        plugin.getServer().getPluginManager().registerEvents(new InventoryListener(), plugin);
    }

    private void loadCustomMenus() {
        File directory = new File(this.plugin.getDataFolder(), "menus");
        this.createMenusDirectoryIfNeeded(directory);
        File[] yamlFiles = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (yamlFiles == null) {
            return;
        }
        for (File file : yamlFiles) {
            String name2 = file.getName().replace(".yml", "");
            if (this.inventories.containsKey(name2)) {
                this.plugin.getLogger().warning("Inventory with name '" + file.getName() + "' already exists, skipping duplicate..");
                continue;
            }
            try {
                CustomGUI customGUI = new CustomGUI(this.plugin, YamlConfiguration.loadConfiguration(file));
                this.inventories.put(name2, customGUI);
                customGUI.onEnable();
                this.plugin.getLogger().info("Loaded custom menu '" + name2 + "'.");
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not load file '" + name2 + "' (YAML error)", e);
            }
        }
    }

    private void createMenusDirectoryIfNeeded(File directory) {
        if (!directory.exists()) {
            if (!directory.mkdir()) {
                this.plugin.getLogger().warning("Failed to create menus directory at: " + directory.getPath());
                return;
            }
            File file = new File(directory, "serverselector.yml");
            if (!file.exists()) {
                try (InputStream inputStream = this.plugin.getResource("serverselector.yml");){
                    if (inputStream != null) {
                        Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        this.plugin.getLogger().info("Created default serverselector.yml menu.");
                    } else {
                        this.plugin.getLogger().warning("Resource 'serverselector.yml' not found.");
                    }
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to copy serverselector.yml to menus directory", e);
                }
            }
        }
    }

    public void addInventory(String key, AbstractInventory inventory) {
        this.inventories.put(key, inventory);
    }

    public Map<String, AbstractInventory> getInventories() {
        return this.inventories;
    }

    public Optional<AbstractInventory> getInventory(String key) {
        return Optional.ofNullable(this.inventories.get(key));
    }

    public void onDisable() {
        this.inventories.values().forEach(abstractInventory -> {
            abstractInventory.getOpenInventories().forEach(uuid -> {
                Player player = Bukkit.getPlayer(uuid);
                if (player != null) {
                    this.scheduler.runAtEntity(player, task -> player.closeInventory());
                }
            });
            abstractInventory.getOpenInventories().clear();
        });
        this.inventories.clear();
    }
}

