/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.inventory.inventories;

import java.util.logging.Level;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.inventory.AbstractInventory;
import net.zithium.deluxehub.inventory.InventoryBuilder;
import net.zithium.deluxehub.inventory.InventoryItem;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import net.zithium.deluxehub.utility.ItemStackBuilder;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;

public class CustomGUI
extends AbstractInventory {
    private InventoryBuilder inventory;
    private final FileConfiguration config;

    public CustomGUI(DeluxeHubPlugin plugin, FileConfiguration config) {
        super(plugin);
        this.config = config;
    }

    @Override
    public void onEnable() {
        InventoryBuilder inventoryBuilder = new InventoryBuilder(this.config.getInt("slots"), ColorUtil.color(this.config.getString("title")));
        if (this.config.contains("refresh") && this.config.getBoolean("refresh.enabled")) {
            this.setInventoryRefresh(this.config.getLong("refresh.rate"));
        }
        for (String entry : this.config.getConfigurationSection("items").getKeys(false)) {
            try {
                ItemStackBuilder builder = ItemStackBuilder.getItemStack(this.config.getConfigurationSection("items." + entry));
                InventoryItem inventoryItem = !this.config.contains("items." + entry + ".actions") ? new InventoryItem(builder.build()) : new InventoryItem(builder.build()).addClickAction(p -> this.getPlugin().getActionManager().executeActions(p, this.config.getStringList("items." + entry + ".actions")));
                if (this.config.contains("items." + entry + ".slots")) {
                    for (String slot : this.config.getStringList("items." + entry + ".slots")) {
                        inventoryBuilder.setItem(Integer.parseInt(slot), inventoryItem);
                    }
                    continue;
                }
                if (!this.config.contains("items." + entry + ".slot")) continue;
                int slot = this.config.getInt("items." + entry + ".slot");
                if (slot == -1) {
                    while (inventoryBuilder.getInventory().firstEmpty() != -1) {
                        inventoryBuilder.setItem(inventoryBuilder.getInventory().firstEmpty(), inventoryItem);
                    }
                    continue;
                }
                inventoryBuilder.setItem(slot, inventoryItem);
            }
            catch (Exception e) {
                this.getPlugin().getLogger().log(Level.WARNING, "Failed to load GUI item ID '" + entry + "', skipping", e);
            }
        }
        this.inventory = inventoryBuilder;
    }

    @Override
    protected Inventory getInventory() {
        return this.inventory.getInventory();
    }
}

