/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.libs.command.bukkit.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.zithium.deluxehub.libs.command.bukkit.util.CommandInfo;
import net.zithium.deluxehub.libs.command.bukkit.util.DynamicPluginCommand;
import net.zithium.deluxehub.libs.command.bukkit.util.DynamicPluginCommandHelpTopic;
import net.zithium.deluxehub.libs.command.bukkit.util.FallbackRegistrationListener;
import net.zithium.deluxehub.libs.command.util.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class CommandRegistration {
    protected final Plugin plugin;
    protected final CommandExecutor executor;
    protected final TabCompleter completer;
    private CommandMap fallbackCommands;

    public CommandRegistration(Plugin plugin) {
        this(plugin, plugin, plugin);
    }

    public CommandRegistration(Plugin plugin, CommandExecutor executor) {
        this(plugin, executor, null);
    }

    public CommandRegistration(Plugin plugin, CommandExecutor executor, @Nullable TabCompleter completer) {
        this.plugin = plugin;
        this.executor = executor;
        this.completer = completer;
    }

    public boolean register(List<CommandInfo> registered) {
        CommandMap commandMap = this.getCommandMap();
        if (registered == null || commandMap == null) {
            return false;
        }
        for (CommandInfo command : registered) {
            DynamicPluginCommand cmd = new DynamicPluginCommand(command.getAliases(), command.getDesc(), "/" + command.getAliases()[0] + " " + command.getUsage(), this.executor, this.completer, command.getRegisteredWith(), this.plugin);
            cmd.setPermissions(command.getPermissions());
            commandMap.register(this.plugin.getDescription().getName(), cmd);
        }
        return true;
    }

    public CommandMap getCommandMap() {
        CommandMap commandMap = (CommandMap)ReflectionUtil.getField(this.plugin.getServer().getPluginManager(), "commandMap");
        if (commandMap == null) {
            if (this.fallbackCommands != null) {
                commandMap = this.fallbackCommands;
            } else {
                Bukkit.getServer().getLogger().severe(this.plugin.getDescription().getName() + ": Could not retrieve server CommandMap, using fallback instead! Please report to http://redmine.sk89q.com");
                this.fallbackCommands = commandMap = new SimpleCommandMap(Bukkit.getServer());
                Bukkit.getServer().getPluginManager().registerEvents(new FallbackRegistrationListener(this.fallbackCommands), this.plugin);
            }
        }
        return commandMap;
    }

    public boolean unregisterCommands() {
        CommandMap commandMap = this.getCommandMap();
        ArrayList<String> toRemove = new ArrayList<String>();
        Map knownCommands = (Map)ReflectionUtil.getField(commandMap, "knownCommands");
        Set aliases = (Set)ReflectionUtil.getField(commandMap, "aliases");
        if (knownCommands == null || aliases == null) {
            return false;
        }
        Iterator i = knownCommands.values().iterator();
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            if (!(cmd instanceof DynamicPluginCommand) || !((DynamicPluginCommand)cmd).getExecutor().equals(this.executor)) continue;
            i.remove();
            for (String alias : cmd.getAliases()) {
                Command aliasCmd = (Command)knownCommands.get(alias);
                if (!cmd.equals(aliasCmd)) continue;
                aliases.remove(alias);
                toRemove.add(alias);
            }
        }
        for (String string : toRemove) {
            knownCommands.remove(string);
        }
        return true;
    }

    static {
        Bukkit.getServer().getHelpMap().registerHelpTopicFactory(DynamicPluginCommand.class, new DynamicPluginCommandHelpTopic.Factory());
    }
}

