/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.libs.command.bukkit.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Provider;
import net.zithium.deluxehub.libs.command.bukkit.util.CommandInfo;
import net.zithium.deluxehub.libs.command.bukkit.util.CommandRegistration;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.CommandsManager;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.annotations.Command;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.annotations.CommandPermissions;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class CommandsManagerRegistration
extends CommandRegistration {
    protected CommandsManager<?> commands;

    public CommandsManagerRegistration(Plugin plugin, CommandsManager<?> commands) {
        super(plugin);
        this.commands = commands;
    }

    public CommandsManagerRegistration(Plugin plugin, CommandExecutor executor, CommandsManager<?> commands) {
        super(plugin, executor);
        this.commands = commands;
    }

    public CommandsManagerRegistration(Plugin plugin, CommandExecutor executor, @Nullable TabCompleter completer, CommandsManager<?> commands) {
        super(plugin, executor, completer);
        this.commands = commands;
    }

    public boolean register(Class<?> clazz) {
        return this.register(clazz, null, null);
    }

    public boolean register(Class<?> clazz, String[] aliases) {
        return this.register(clazz, null, aliases);
    }

    public <T> boolean register(Class<T> clazz, @Nullable Provider<? extends T> provider, String[] aliases) {
        return this.registerAll(this.commands.registerMethods(clazz, null, provider), aliases);
    }

    public boolean registerAll(List<Command> registered, String[] aliases) {
        ArrayList<CommandInfo> toRegister = new ArrayList<CommandInfo>();
        for (Command command : registered) {
            String[] permissions = null;
            Method cmdMethod = this.commands.getMethods().get(null).get(command.aliases()[0]);
            if (cmdMethod != null && cmdMethod.isAnnotationPresent(CommandPermissions.class)) {
                permissions = cmdMethod.getAnnotation(CommandPermissions.class).value();
            }
            String[] cmdAliases = command.aliases();
            if (aliases != null) {
                cmdAliases = (String[])ArrayUtils.addAll(command.aliases(), aliases);
            }
            toRegister.add(new CommandInfo(command.usage(), command.desc(), cmdAliases, this.commands, permissions));
        }
        return ((CommandRegistration)this).register(toRegister);
    }
}

