/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.libs.command.minecraft.util.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.CommandLocals;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.SuggestionContext;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandException;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandNumberFormatException;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandUsageException;
import net.zithium.deluxehub.libs.command.minecraft.util.commands.exceptions.SuggestException;

public class CommandContext {
    protected final String[] originalArgs;
    protected final String command;
    protected final List<String> parsedArgs = new ArrayList<String>();
    protected final List<Integer> originalArgIndices = new ArrayList<Integer>();
    protected final Set<Character> booleanFlags = new HashSet<Character>();
    protected final Map<Character, String> valueFlags = new HashMap<Character, String>();
    @Nullable
    protected final SuggestionContext suggestionContext;
    protected final CommandLocals locals;

    public CommandContext(String[] args, Set<Character> valueFlags, boolean completing) throws CommandException {
        this(args, valueFlags, completing, null);
    }

    public CommandContext(String[] args, @Nullable Set<Character> valueFlagNames, boolean completing, @Nullable CommandLocals locals) throws CommandException {
        if (valueFlagNames == null) {
            valueFlagNames = Collections.emptySet();
        }
        this.originalArgs = args;
        this.command = args[0];
        CommandLocals commandLocals = this.locals = locals != null ? locals : new CommandLocals();
        if (args.length < 2) {
            completing = false;
        }
        boolean acceptingFlags = true;
        Character valueFlag = null;
        Character completingFlag = null;
        int completingIndex = -1;
        for (int argIndex = 1; argIndex < args.length; ++argIndex) {
            String arg = args[argIndex];
            int startIndex = argIndex;
            if (arg.isEmpty()) {
                if (!completing || argIndex != args.length - 1) {
                    continue;
                }
            } else {
                char c = arg.charAt(0);
                if (c == '\\' || c == '\"') {
                    boolean first = true;
                    while (argIndex < args.length) {
                        String part;
                        if (first) {
                            first = false;
                            part = args[argIndex].substring(1);
                        } else {
                            arg = arg + ' ';
                            part = args[argIndex];
                        }
                        if (!part.isEmpty() && part.charAt(part.length() - 1) == c) {
                            arg = arg + part.substring(0, part.length() - 1);
                            break;
                        }
                        arg = arg + part;
                        ++argIndex;
                    }
                } else if (valueFlag == null) {
                    if ("--".equals(arg)) {
                        acceptingFlags = false;
                        arg = null;
                    } else if (acceptingFlags && arg.matches("^-[a-zA-Z?]+$")) {
                        for (int iFlag = 1; iFlag < arg.length(); ++iFlag) {
                            char flagName = arg.charAt(iFlag);
                            if (valueFlagNames.contains(Character.valueOf(flagName))) {
                                if (this.valueFlags.containsKey(Character.valueOf(flagName))) {
                                    throw new CommandException("Value flag '" + flagName + "' already given");
                                }
                                if (valueFlag == null) {
                                    valueFlag = Character.valueOf(flagName);
                                    continue;
                                }
                                throw new CommandException("No value specified for the '-" + flagName + "' flag.");
                            }
                            this.booleanFlags.add(Character.valueOf(flagName));
                        }
                        arg = null;
                    }
                }
            }
            if (arg == null) continue;
            if (valueFlag == null) {
                if (completing) {
                    completingIndex = this.parsedArgs.size();
                    completingFlag = null;
                }
                this.parsedArgs.add(arg);
                this.originalArgIndices.add(startIndex);
                continue;
            }
            if (completing) {
                completingIndex = -1;
                completingFlag = valueFlag;
            }
            this.valueFlags.put(valueFlag, arg);
            valueFlag = null;
        }
        if (valueFlag != null) {
            throw new CommandException("No value specified for the '-" + valueFlag + "' flag.");
        }
        if (completing) {
            String context = "";
            for (int i = 1; i < args.length - 1; ++i) {
                context = context + args[i] + ' ';
            }
            this.suggestionContext = new SuggestionContext(context, args[args.length - 1], completingIndex, completingFlag);
        } else {
            this.suggestionContext = null;
        }
    }

    @Nullable
    public SuggestionContext getSuggestionContext() {
        return this.suggestionContext;
    }

    public boolean isExecuting() {
        return this.getSuggestionContext() == null;
    }

    public boolean isSuggesting() {
        return this.getSuggestionContext() != null;
    }

    public boolean isSuggestingArgument(int index) {
        return this.isSuggesting() && this.getSuggestionContext().isArgument(index);
    }

    public boolean isSuggestingFlag(char flag) {
        return this.isSuggesting() && this.getSuggestionContext().isFlag(flag);
    }

    public void suggestArgument(int index, Iterable<String> choices) throws SuggestException {
        if (this.isSuggesting() && this.getSuggestionContext().isArgument()) {
            this.getSuggestionContext().suggestArgument(index, choices);
        }
    }

    public void suggestFlag(char flag, Iterable<String> choices) throws SuggestException {
        if (this.isSuggesting()) {
            this.getSuggestionContext().suggestFlag(flag, choices);
        }
    }

    public void suggestJoinedArguments(int start, Iterable<String> choices) throws SuggestException {
        SuggestionContext ctx = this.getSuggestionContext();
        if (ctx != null && ctx.isArgument()) {
            if (start == ctx.getIndex()) {
                ctx.suggestArgument(start, choices);
            } else if (start < ctx.getIndex()) {
                String prefix = String.join((CharSequence)" ", this.parsedArgs.subList(start, ctx.getIndex())).toLowerCase() + " ";
                ArrayList<String> filtered = new ArrayList<String>();
                for (String choice : choices) {
                    if (!choice.toLowerCase().startsWith(prefix)) continue;
                    filtered.add(choice.substring(prefix.length()));
                }
                ctx.suggestArgument(ctx.getIndex(), filtered);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getOriginalArgs() {
        return this.originalArgs;
    }

    public boolean matches(String command) {
        return this.command.equalsIgnoreCase(command);
    }

    public String getString(int index) {
        return this.parsedArgs.get(index);
    }

    public Optional<String> tryString(int index) {
        return index < this.parsedArgs.size() ? Optional.of(this.parsedArgs.get(index)) : Optional.empty();
    }

    public String getString(int index, String def) {
        return index < this.parsedArgs.size() ? this.parsedArgs.get(index) : def;
    }

    public String string(int index) throws CommandException {
        if (index >= this.parsedArgs.size()) {
            throw new CommandUsageException("Missing argument");
        }
        return this.getString(index);
    }

    public String string(int index, Iterable<String> choices) throws CommandException, SuggestException {
        this.suggestArgument(index, choices);
        return this.string(index);
    }

    public Optional<String> tryString(int index, Iterable<String> choices) throws SuggestException {
        this.suggestArgument(index, choices);
        return this.tryString(index);
    }

    public String getJoinedStrings(int initialIndex) {
        initialIndex = this.originalArgIndices.get(initialIndex);
        StringBuilder buffer = new StringBuilder(this.originalArgs[initialIndex]);
        for (int i = initialIndex + 1; i < this.originalArgs.length; ++i) {
            buffer.append(" ").append(this.originalArgs[i]);
        }
        return buffer.toString();
    }

    public String getJoinedStrings(int initialIndex, String def) {
        return initialIndex < this.originalArgIndices.size() ? this.getJoinedStrings(initialIndex) : def;
    }

    public String joinedStrings(int initialIndex) throws CommandException {
        if (initialIndex >= this.originalArgIndices.size()) {
            throw new CommandUsageException("Missing argument");
        }
        return this.getJoinedStrings(initialIndex);
    }

    public String joinedStrings(int initialIndex, Iterable<String> choices) throws CommandException, SuggestException {
        this.suggestJoinedArguments(initialIndex, choices);
        return this.joinedStrings(initialIndex);
    }

    public Optional<String> tryJoinedStrings(int initialIndex) {
        return initialIndex < this.originalArgIndices.size() ? Optional.of(this.getJoinedStrings(initialIndex)) : Optional.empty();
    }

    public Optional<String> tryJoinedStrings(int initialIndex, Iterable<String> choices) throws SuggestException {
        this.suggestJoinedArguments(initialIndex, choices);
        return this.tryJoinedStrings(initialIndex);
    }

    public String getRemainingString(int start) {
        return this.getString(start, this.parsedArgs.size() - 1);
    }

    public String remainingString(int start) throws CommandException {
        return this.string(start, this.parsedArgs.size() - 1);
    }

    public String remainingString(int start, Iterable<String> choices) throws CommandException, SuggestException {
        this.suggestJoinedArguments(start, choices);
        return this.remainingString(start);
    }

    public Optional<String> tryRemainingString(int start) {
        return this.tryString(start, this.parsedArgs.size() - 1);
    }

    public Optional<String> tryRemainingString(int start, Iterable<String> choices) throws SuggestException {
        this.suggestJoinedArguments(start, choices);
        return this.tryRemainingString(start);
    }

    public String getString(int start, int end) {
        StringBuilder buffer = new StringBuilder(this.parsedArgs.get(start));
        for (int i = start + 1; i < end + 1; ++i) {
            buffer.append(" ").append(this.parsedArgs.get(i));
        }
        return buffer.toString();
    }

    public String string(int start, int end) throws CommandException {
        if (start >= this.parsedArgs.size() || end >= this.parsedArgs.size()) {
            throw new CommandUsageException("Missing argument");
        }
        return this.getString(start, end);
    }

    public Optional<String> tryString(int start, int end) {
        return start < this.parsedArgs.size() && end < this.parsedArgs.size() ? Optional.of(this.getString(start, end)) : Optional.empty();
    }

    public int getInteger(int index) throws CommandNumberFormatException {
        String text = this.parsedArgs.get(index);
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new CommandNumberFormatException(text);
        }
    }

    public int getInteger(int index, int def) throws CommandNumberFormatException {
        return index < this.parsedArgs.size() ? this.getInteger(index) : def;
    }

    public double getDouble(int index) throws CommandNumberFormatException {
        String text = this.parsedArgs.get(index);
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            throw new CommandNumberFormatException(text);
        }
    }

    public double getDouble(int index, double def) throws CommandNumberFormatException {
        return index < this.parsedArgs.size() ? this.getDouble(index) : def;
    }

    public String[] getSlice(int index) {
        String[] slice = new String[this.originalArgs.length - index];
        System.arraycopy(this.originalArgs, index, slice, 0, this.originalArgs.length - index);
        return slice;
    }

    public String[] getPaddedSlice(int index, int padding) {
        String[] slice = new String[this.originalArgs.length - index + padding];
        System.arraycopy(this.originalArgs, index, slice, padding, this.originalArgs.length - index);
        return slice;
    }

    public String[] getParsedSlice(int index) {
        String[] slice = new String[this.parsedArgs.size() - index];
        System.arraycopy(this.parsedArgs.toArray(new String[this.parsedArgs.size()]), index, slice, 0, this.parsedArgs.size() - index);
        return slice;
    }

    public String[] getParsedPaddedSlice(int index, int padding) {
        String[] slice = new String[this.parsedArgs.size() - index + padding];
        System.arraycopy(this.parsedArgs.toArray(new String[this.parsedArgs.size()]), index, slice, padding, this.parsedArgs.size() - index);
        return slice;
    }

    public boolean hasFlag(char ch) {
        return this.booleanFlags.contains(Character.valueOf(ch)) || this.valueFlags.containsKey(Character.valueOf(ch));
    }

    public Set<Character> getFlags() {
        return this.booleanFlags;
    }

    public Map<Character, String> getValueFlags() {
        return this.valueFlags;
    }

    @Nullable
    public String getFlag(char ch) {
        return this.valueFlags.get(Character.valueOf(ch));
    }

    public String getFlag(char ch, String def) {
        String value = this.valueFlags.get(Character.valueOf(ch));
        if (value == null) {
            return def;
        }
        return value;
    }

    @Nullable
    public String flagOrNull(char ch, Iterable<String> choices) throws SuggestException {
        this.suggestFlag(ch, choices);
        return this.getFlag(ch);
    }

    public Optional<String> tryFlag(char ch) {
        return Optional.ofNullable(this.getFlag(ch));
    }

    public Optional<String> tryFlag(char ch, Iterable<String> choices) throws SuggestException {
        this.suggestFlag(ch, choices);
        return this.tryFlag(ch);
    }

    public int getFlagInteger(char ch) throws CommandNumberFormatException {
        String text = this.valueFlags.get(Character.valueOf(ch));
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new CommandNumberFormatException(text);
        }
    }

    public int getFlagInteger(char ch, int def) throws CommandNumberFormatException {
        return !this.valueFlags.containsKey(Character.valueOf(ch)) ? def : this.getFlagInteger(ch);
    }

    public double getFlagDouble(char ch) throws CommandNumberFormatException {
        String text = this.valueFlags.get(Character.valueOf(ch));
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            throw new CommandNumberFormatException(text);
        }
    }

    public double getFlagDouble(char ch, double def) throws CommandNumberFormatException {
        return !this.valueFlags.containsKey(Character.valueOf(ch)) ? def : this.getFlagDouble(ch);
    }

    public int argsLength() {
        return this.parsedArgs.size();
    }

    public CommandLocals getLocals() {
        return this.locals;
    }
}

