/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.chat;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.Permissions;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AntiSwear
extends Module {
    private List<String> blockedWords;

    public AntiSwear(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.ANTI_SWEAR);
        try {
            Class.forName("io.papermc.paper.event.player.AsyncChatEvent", false, plugin.getClass().getClassLoader());
            plugin.getServer().getPluginManager().registerEvents(new PaperHandler(plugin, this), plugin);
        }
        catch (ClassNotFoundException ignored) {
            plugin.getServer().getPluginManager().registerEvents(new SpigotHandler(plugin, this), plugin);
        }
    }

    @Override
    public void onEnable() {
        this.blockedWords = this.getConfig(ConfigType.SETTINGS).getStringList("anti_swear.blocked_words");
    }

    @Override
    public void onDisable() {
    }

    private void handleSwearCheck(Player player, String message, Runnable cancelAction) {
        if (player.hasPermission(Permissions.ANTI_SWEAR_BYPASS.getPermission())) {
            return;
        }
        for (String word : this.blockedWords) {
            if (!message.toLowerCase().contains(word.toLowerCase())) continue;
            cancelAction.run();
            Messages.ANTI_SWEAR_WORD_BLOCKED.send(player, new Object[0]);
            Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission(Permissions.ANTI_SWEAR_NOTIFY.getPermission())).forEach(p -> Messages.ANTI_SWEAR_ADMIN_NOTIFY.send((CommandSender)p, "%player%", player.getName(), "%word%", message));
            return;
        }
    }

    private record PaperHandler(DeluxeHubPlugin plugin, AntiSwear antiSwear) implements Listener
    {
        @EventHandler(priority=EventPriority.HIGHEST)
        public void onPlayerChat(AsyncChatEvent event) {
            Player player = event.getPlayer();
            String message = PlainTextComponentSerializer.plainText().serialize(event.message()).trim();
            this.antiSwear.handleSwearCheck(player, message, () -> event.setCancelled(true));
        }
    }

    private record SpigotHandler(DeluxeHubPlugin plugin, AntiSwear antiSwear) implements Listener
    {
        @EventHandler(priority=EventPriority.HIGHEST)
        public void onPlayerChat(AsyncPlayerChatEvent event) {
            Player player = event.getPlayer();
            String message = event.getMessage().trim();
            this.antiSwear.handleSwearCheck(player, message, () -> event.setCancelled(true));
        }
    }
}

