/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.chat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.folialib.wrapper.task.WrappedTask;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import net.zithium.deluxehub.libs.xseries.XSound;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class AutoBroadcast
extends Module
implements Runnable {
    private final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private Map<Integer, List<String>> broadcasts;
    private WrappedTask broadcastTask = null;
    private int count = 0;
    private int size = 0;
    private int requiredPlayers = 0;
    private Sound sound = null;
    private double volume;
    private double pitch;

    public AutoBroadcast(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.ANNOUNCEMENTS);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.broadcasts = new HashMap<Integer, List<String>>();
        int count = 0;
        for (String key : config.getConfigurationSection("announcements.announcements").getKeys(false)) {
            this.broadcasts.put(count, config.getStringList("announcements.announcements." + key));
            ++count;
        }
        if (config.getBoolean("announcements.sound.enabled")) {
            this.sound = XSound.matchXSound(config.getString("announcements.sound.value")).get().parseSound();
            this.volume = config.getDouble("announcements.sound.volume");
            this.pitch = config.getDouble("announcements.sound.pitch");
        }
        this.requiredPlayers = config.getInt("announcements.required_players", 0);
        this.size = this.broadcasts.size();
        if (this.size > 0) {
            this.broadcastTask = this.scheduler.runTimer(this, 60L, (long)config.getInt("announcements.delay") * 20L);
        }
    }

    @Override
    public void onDisable() {
        if (this.broadcastTask != null) {
            this.broadcastTask.cancel();
        }
    }

    @Override
    public void run() {
        if (this.count == this.size) {
            this.count = 0;
        }
        if (this.count < this.size && Bukkit.getOnlinePlayers().size() >= this.requiredPlayers) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (this.inDisabledWorld(player.getLocation())) continue;
                this.broadcasts.get(this.count).forEach(message -> player.sendMessage(ColorUtil.color(message)));
                if (this.sound == null) continue;
                player.playSound(player.getLocation(), this.sound, (float)this.volume, (float)this.pitch);
            }
            ++this.count;
        }
    }
}

