/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.chat;

import io.papermc.paper.event.player.AsyncChatEvent;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.Permissions;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatLock
extends Module {
    private boolean isChatLocked;

    public ChatLock(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.CHAT_LOCK);
        try {
            Class.forName("io.papermc.paper.event.player.AsyncChatEvent", false, plugin.getClass().getClassLoader());
            plugin.getServer().getPluginManager().registerEvents(new PaperHandler(plugin, this), plugin);
        }
        catch (ClassNotFoundException ignored) {
            plugin.getServer().getPluginManager().registerEvents(new SpigotHandler(plugin, this), plugin);
        }
    }

    @Override
    public void onEnable() {
        this.isChatLocked = this.getPlugin().getConfigManager().getFile(ConfigType.DATA).getConfig().getBoolean("chat_locked");
    }

    @Override
    public void onDisable() {
        this.getPlugin().getConfigManager().getFile(ConfigType.DATA).getConfig().set("chat_locked", this.isChatLocked);
    }

    private void handleChatLock(Player player, Runnable cancelAction) {
        if (!this.isChatLocked || player.hasPermission(Permissions.LOCK_CHAT_BYPASS.getPermission())) {
            return;
        }
        cancelAction.run();
        Messages.CHAT_LOCKED.send(player, new Object[0]);
    }

    public boolean isChatLocked() {
        return this.isChatLocked;
    }

    public void setChatLocked(boolean chatLocked) {
        this.isChatLocked = chatLocked;
    }

    private record PaperHandler(DeluxeHubPlugin plugin, ChatLock chatLock) implements Listener
    {
        @EventHandler(priority=EventPriority.HIGHEST)
        public void onPlayerChat(AsyncChatEvent event) {
            Player player = event.getPlayer();
            this.chatLock.handleChatLock(player, () -> event.setCancelled(true));
        }
    }

    private record SpigotHandler(DeluxeHubPlugin plugin, ChatLock chatLock) implements Listener
    {
        @EventHandler(priority=EventPriority.HIGHEST)
        public void onPlayerChat(AsyncPlayerChatEvent event) {
            Player player = event.getPlayer();
            this.chatLock.handleChatLock(player, () -> event.setCancelled(true));
        }
    }
}

