/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.chat;

import java.util.List;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.command.CustomCommand;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CustomCommands
extends Module {
    private List<CustomCommand> commands;

    public CustomCommands(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.CUSTOM_COMMANDS);
    }

    @Override
    public void onEnable() {
        this.commands = this.getPlugin().getCommandManager().getCustomCommands();
    }

    @Override
    public void onDisable() {
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        String command = event.getMessage().toLowerCase().replace("/", "");
        for (CustomCommand customCommand : this.commands) {
            if (!customCommand.getAliases().stream().anyMatch(alias -> alias.equals(command))) continue;
            if (customCommand.getPermission() != null && !player.hasPermission(customCommand.getPermission())) {
                Messages.CUSTOM_COMMAND_NO_PERMISSION.send(player, new Object[0]);
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            this.getPlugin().getActionManager().executeActions(player, customCommand.getActions());
        }
    }
}

