/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.hologram;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import net.zithium.deluxehub.utility.TeleportUtil;
import net.zithium.deluxehub.utility.reflection.ArmorStandName;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;

public class Hologram {
    private static final double LINE_HEIGHT = 0.25;
    private final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private final DeluxeHubPlugin plugin;
    private final List<ArmorStand> stands;
    private final AtomicInteger lineCounter;
    private Location location;
    private final String name;

    public Hologram(DeluxeHubPlugin plugin, String name, Location location) {
        this.plugin = plugin;
        this.name = name;
        this.location = location;
        this.stands = new CopyOnWriteArrayList<ArmorStand>();
        this.lineCounter = new AtomicInteger(0);
    }

    public Hologram setLines(List<String> lines) {
        CopyOnWriteArrayList<ArmorStand> oldStands = new CopyOnWriteArrayList<ArmorStand>(this.stands);
        this.stands.clear();
        this.lineCounter.set(0);
        for (ArmorStand stand : oldStands) {
            this.scheduler.runAtEntity(stand, task -> stand.remove());
        }
        for (String s : lines) {
            this.addLine(s);
        }
        return this;
    }

    public Hologram addLine(String text) {
        int currentIndex = this.lineCounter.getAndIncrement();
        double height = (double)currentIndex * 0.25;
        this.scheduler.runAtLocation(this.location, task -> {
            ArmorStand stand = (ArmorStand)this.location.getWorld().spawnEntity(this.location.clone().subtract(0.0, height, 0.0), EntityType.ARMOR_STAND);
            stand.setVisible(false);
            stand.setGravity(false);
            stand.setCustomNameVisible(true);
            stand.setCustomName(ColorUtil.color(text).trim());
            stand.setCanPickupItems(false);
            this.stands.add(stand);
        });
        return this;
    }

    public Hologram setLine(int line, String text) {
        if (line < 1 || line > this.stands.size()) {
            return this;
        }
        ArmorStand stand = this.stands.get(line - 1);
        this.scheduler.runAtEntity(stand, task -> stand.setCustomName(ColorUtil.color(text).trim()));
        return this;
    }

    public Hologram removeLine(int line) {
        if (line < 1 || line > this.stands.size()) {
            return this;
        }
        ArmorStand stand = this.stands.get(line - 1);
        int index = line - 1;
        this.scheduler.runAtEntity(stand, task -> {
            stand.remove();
            this.stands.remove(index);
            this.lineCounter.decrementAndGet();
            this.refreshLines(index);
        });
        return this;
    }

    public boolean refreshLines(int line) {
        ArrayList<ArmorStand> standsTemp = new ArrayList<ArmorStand>();
        int count = 0;
        for (ArmorStand entry : this.stands) {
            if (count >= line) {
                standsTemp.add(entry);
            }
            ++count;
        }
        for (ArmorStand stand : standsTemp) {
            Location newLocation = stand.getLocation().add(0.0, 0.25, 0.0);
            TeleportUtil.teleportCompat(stand, newLocation);
        }
        return count >= 1;
    }

    public Hologram setLocation(Location location) {
        this.location = location;
        this.setLines(this.stands.stream().map(ArmorStandName::getName).collect(Collectors.toList()));
        return this;
    }

    public boolean hasLine(int line) {
        return line - 1 < this.stands.size() && line > 0;
    }

    public void remove() {
        if (this.plugin.isEnabled()) {
            for (ArmorStand stand : this.stands) {
                this.scheduler.runAtEntity(stand, task -> stand.remove());
            }
        }
        this.stands.clear();
        this.lineCounter.set(0);
    }

    public Location getLocation() {
        return this.location;
    }

    public List<ArmorStand> getStands() {
        return this.stands;
    }

    public String getName() {
        return this.name;
    }
}

