/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.hologram;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.module.modules.hologram.Hologram;
import net.zithium.deluxehub.utility.reflection.ArmorStandName;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

public class HologramManager
extends Module {
    private final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private Set<Hologram> holograms;

    public HologramManager(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.HOLOGRAMS);
    }

    @Override
    public void onEnable() {
        this.holograms = ConcurrentHashMap.newKeySet();
        this.loadHolograms();
    }

    @Override
    public void onDisable() {
        this.saveHologramsData();
        this.removeAllHologramEntities();
    }

    public void loadHolograms() {
        this.scheduler.runLater(() -> {
            FileConfiguration config = this.getConfig(ConfigType.DATA);
            if (config.contains("holograms")) {
                for (String key : config.getConfigurationSection("holograms").getKeys(false)) {
                    List<String> lines = config.getStringList("holograms." + key + ".lines");
                    Location loc = (Location)config.get("holograms." + key + ".location");
                    if (loc == null) continue;
                    this.deleteNearbyHolograms(loc);
                    Hologram holo = this.createHologram(key, loc);
                    holo.setLines(lines);
                }
            }
        }, 40L);
    }

    public void saveHolograms() {
        this.saveHologramsData();
        this.deleteAllHolograms();
    }

    private void saveHologramsData() {
        FileConfiguration config = this.getConfig(ConfigType.DATA);
        this.holograms.forEach(hologram -> {
            config.set("holograms." + hologram.getName() + ".location", hologram.getLocation());
            ArrayList<String> lines = new ArrayList<String>();
            for (ArmorStand stand : hologram.getStands()) {
                lines.add(ArmorStandName.getName(stand));
            }
            config.set("holograms." + hologram.getName() + ".lines", lines);
        });
        this.getPlugin().getConfigManager().getFile(ConfigType.DATA).save();
    }

    public Set<Hologram> getHolograms() {
        return this.holograms;
    }

    public boolean hasHologram(String name) {
        return this.getHolograms().stream().anyMatch(hologram -> hologram.getName().equalsIgnoreCase(name));
    }

    public Hologram getHologram(String name) {
        return this.getHolograms().stream().filter(hologram -> hologram.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Hologram createHologram(String name, Location location) {
        Hologram holo = new Hologram(this.getPlugin(), name, location);
        this.holograms.add(holo);
        return holo;
    }

    public void deleteHologram(String name) {
        Hologram holo = this.getHologram(name);
        holo.remove();
        this.holograms.remove(holo);
        this.getConfig(ConfigType.DATA).set("holograms." + name, null);
        this.getPlugin().getConfigManager().getFile(ConfigType.DATA).save();
    }

    public void deleteAllHolograms() {
        for (Hologram hologram : this.holograms) {
            hologram.remove();
        }
        this.holograms.clear();
    }

    private void removeAllHologramEntities() {
        for (Hologram hologram : this.holograms) {
            for (ArmorStand stand : hologram.getStands()) {
                if (stand == null || !stand.isValid()) continue;
                stand.remove();
            }
        }
    }

    public void deleteNearbyHolograms(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        this.scheduler.runAtLocation(location, task -> world.getNearbyEntities(location, 0.5, 20.0, 0.5).stream().filter(entity -> entity instanceof ArmorStand).forEach(entity -> this.scheduler.runAtEntity((Entity)entity, nextTask -> entity.remove())));
    }
}

