/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.hotbar.items;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.cooldown.CooldownType;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.nbt.NBTItem;
import net.zithium.deluxehub.module.modules.hotbar.HotbarItem;
import net.zithium.deluxehub.module.modules.hotbar.HotbarManager;
import net.zithium.deluxehub.utility.ItemStackBuilder;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerHider
extends HotbarItem {
    private final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private final int cooldown;
    private final ItemStack hiddenItem;
    private final List<UUID> hidden = new CopyOnWriteArrayList<UUID>();

    public PlayerHider(HotbarManager hotbarManager, ItemStack item, int slot, String key) {
        super(hotbarManager, item, slot, key);
        FileConfiguration config = this.getHotbarManager().getConfig(ConfigType.SETTINGS);
        NBTItem nbtItem = new NBTItem(ItemStackBuilder.getItemStack(config.getConfigurationSection("player_hider.hidden")).build());
        nbtItem.setString("hotbarItem", key);
        this.hiddenItem = nbtItem.getItem();
        this.cooldown = config.getInt("player_hider.cooldown");
    }

    @Override
    protected void onInteract(Player player) {
        if (!this.getHotbarManager().tryCooldown(player.getUniqueId(), CooldownType.PLAYER_HIDER, this.cooldown)) {
            Messages.COOLDOWN_ACTIVE.send(player, "%time%", this.getHotbarManager().getCooldown(player.getUniqueId(), CooldownType.PLAYER_HIDER));
            return;
        }
        if (!this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
                this.hidePlayer(player, player2);
            }
            this.hidden.add(player.getUniqueId());
            Messages.PLAYER_HIDER_HIDDEN.send(player, new Object[0]);
            player.getInventory().setItem(this.getSlot(), this.hiddenItem);
        } else {
            for (Player player3 : Bukkit.getServer().getOnlinePlayers()) {
                this.showPlayer(player, player3);
            }
            this.hidden.remove(player.getUniqueId());
            Messages.PLAYER_HIDER_SHOWN.send(player, new Object[0]);
            player.getInventory().setItem(this.getSlot(), this.getItem());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
                this.showPlayer(player, player2);
            }
        }
        this.hidden.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.hidden.forEach(uuid -> {
            Player hiddenPlayer = Bukkit.getPlayer(uuid);
            if (hiddenPlayer != null) {
                this.hidePlayer(hiddenPlayer, player);
            }
        });
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation()) && this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                this.showPlayer(player, player2);
            }
            this.hidden.remove(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawnEvent(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                this.showPlayer(player, player2);
            }
            this.hidden.remove(player.getUniqueId());
        }
    }

    private void hidePlayer(Player source, Player target) {
        if (!Bukkit.isOwnedByCurrentRegion((Entity)source) || !Bukkit.isOwnedByCurrentRegion((Entity)target)) {
            return;
        }
        this.scheduler.runAtEntity(source, task -> source.hidePlayer(target));
    }

    private void showPlayer(Player source, Player target) {
        if (!Bukkit.isOwnedByCurrentRegion((Entity)source) || !Bukkit.isOwnedByCurrentRegion((Entity)target)) {
            return;
        }
        this.scheduler.runAtEntity(source, task -> source.showPlayer(target));
    }
}

