/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.player;

import java.util.ArrayList;
import java.util.List;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.utility.PlaceholderUtil;
import net.zithium.deluxehub.utility.TextUtil;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.meta.FireworkMeta;

public class PlayerListener
extends Module {
    private final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private boolean joinQuitMessagesEnabled;
    private String joinMessage;
    private String quitMessage;
    private List<String> joinActions;
    private boolean spawnHeal;
    private boolean extinguish;
    private boolean clearInventory;
    private boolean fireworkEnabled;
    private boolean fireworkFirstJoin;
    private boolean fireworkFlicker;
    private boolean fireworkTrail;
    private int fireworkPower;
    private String fireworkType;
    private List<Color> fireworkColors;

    public PlayerListener(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.PLAYER_LISTENER);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.joinQuitMessagesEnabled = config.getBoolean("join_leave_messages.enabled");
        this.joinMessage = config.getString("join_leave_messages.join_message");
        this.quitMessage = config.getString("join_leave_messages.quit_message");
        this.joinActions = config.getStringList("join_events");
        this.spawnHeal = config.getBoolean("join_settings.heal", false);
        this.extinguish = config.getBoolean("join_settings.extinguish", false);
        this.clearInventory = config.getBoolean("join_settings.clear_inventory", false);
        this.fireworkEnabled = config.getBoolean("join_settings.firework.enabled", true);
        if (this.fireworkEnabled) {
            this.fireworkFirstJoin = config.getBoolean("join_settings.firework.first_join_only", true);
            this.fireworkType = config.getString("join_settings.firework.type", "BALL_LARGE");
            this.fireworkPower = config.getInt("join_settings.firework.power", 1);
            this.fireworkFlicker = config.getBoolean("join_settings.firework.flicker", true);
            this.fireworkTrail = config.getBoolean("join_settings.firework.power", true);
            this.fireworkColors = new ArrayList<Color>();
            config.getStringList("join_settings.firework.colors").forEach(c -> {
                Color color = TextUtil.getColor(c);
                if (color != null) {
                    this.fireworkColors.add(color);
                }
            });
        }
    }

    @Override
    public void onDisable() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (this.joinQuitMessagesEnabled) {
            if (this.joinMessage.isEmpty()) {
                event.joinMessage(null);
            } else {
                String message = PlaceholderUtil.setPlaceholders(this.joinMessage, player);
                event.setJoinMessage(ColorUtil.color(message));
            }
        }
        if (this.spawnHeal) {
            player.setFoodLevel(20);
            player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        }
        if (this.extinguish) {
            player.setFireTicks(0);
        }
        if (this.clearInventory) {
            player.getInventory().clear();
        }
        this.scheduler.runLater(task -> {
            this.executeActions(player, this.joinActions);
            if (this.fireworkEnabled) {
                if (this.fireworkFirstJoin) {
                    if (!player.hasPlayedBefore()) {
                        this.spawnFirework(player);
                    }
                } else {
                    this.spawnFirework(player);
                }
            }
        }, 3L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (this.joinQuitMessagesEnabled) {
            if (this.quitMessage.isEmpty()) {
                event.quitMessage(null);
            } else {
                String message = PlaceholderUtil.setPlaceholders(this.quitMessage, player);
                event.setQuitMessage(ColorUtil.color(message));
            }
        }
        this.scheduler.runAtEntity(player, task -> player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType())));
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            this.scheduler.runAtEntity(player, task -> player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType())));
        }
    }

    public void spawnFirework(Player player) {
        this.scheduler.runAtLocation(player.getLocation(), task -> {
            Firework firework = player.getWorld().spawn(player.getLocation(), Firework.class);
            FireworkMeta fireworkMeta = firework.getFireworkMeta();
            fireworkMeta.addEffect(FireworkEffect.builder().flicker(this.fireworkFlicker).trail(this.fireworkTrail).with(FireworkEffect.Type.valueOf(this.fireworkType)).withColor(this.fireworkColors).build());
            fireworkMeta.setPower(this.fireworkPower);
            firework.setFireworkMeta(fireworkMeta);
        });
    }
}

