/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.visual.tablist;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Level;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import net.zithium.deluxehub.libs.xseries.reflection.XReflection;
import net.zithium.deluxehub.utility.reflection.ReflectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TablistHelper {
    private static final JavaPlugin PLUGIN = JavaPlugin.getProvidingPlugin(DeluxeHubPlugin.class);

    public static void sendTabList(Player player, String header, String footer) {
        Objects.requireNonNull(player, "Cannot update tab for null player");
        header = Strings.isNullOrEmpty(header) ? "" : ColorUtil.color(header).replace("%player%", player.getDisplayName());
        String string = footer = Strings.isNullOrEmpty(footer) ? "" : ColorUtil.color(footer).replace("%player%", player.getDisplayName());
        if (XReflection.supports(13)) {
            player.setPlayerListHeaderFooter(header, footer);
            return;
        }
        try {
            Field bField;
            Field aField;
            Method chatComponentBuilderMethod = ReflectionUtils.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class);
            Object tabHeader = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + header + "\"}");
            Object tabFooter = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + footer + "\"}");
            Object packet = ReflectionUtils.getNMSClass("PacketPlayOutPlayerListHeaderFooter").getConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                aField = packet.getClass().getDeclaredField("a");
                bField = packet.getClass().getDeclaredField("b");
            }
            catch (Exception ex) {
                aField = packet.getClass().getDeclaredField("header");
                bField = packet.getClass().getDeclaredField("footer");
            }
            aField.setAccessible(true);
            aField.set(packet, tabHeader);
            bField.setAccessible(true);
            bField.set(packet, tabFooter);
            ReflectionUtils.sendPacket(player, packet);
        }
        catch (Exception ex) {
            PLUGIN.getLogger().log(Level.SEVERE, "Failed to send tablist header/footer to player " + player.getName(), ex);
        }
    }
}

