/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.visual.tablist;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.folialib.wrapper.task.WrappedTask;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.module.modules.visual.tablist.TablistHelper;
import net.zithium.deluxehub.module.modules.visual.tablist.TablistUpdateTask;
import net.zithium.deluxehub.utility.PlaceholderUtil;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TablistManager
extends Module {
    private final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private List<UUID> players;
    private WrappedTask tablistTask;
    private String header;
    private String footer;

    public TablistManager(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.TABLIST);
    }

    @Override
    public void onEnable() {
        this.players = new CopyOnWriteArrayList<UUID>();
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.header = String.join((CharSequence)"\n", config.getStringList("tablist.header"));
        this.footer = String.join((CharSequence)"\n", config.getStringList("tablist.footer"));
        if (config.getBoolean("tablist.refresh.enabled")) {
            this.tablistTask = this.scheduler.runTimer(new TablistUpdateTask(this), 1L, config.getLong("tablist.refresh.rate"));
        }
        this.scheduler.runLater(() -> Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(this::createTablist), 20L);
    }

    @Override
    public void onDisable() {
        if (this.tablistTask != null) {
            this.tablistTask.cancel();
        }
        Bukkit.getOnlinePlayers().forEach(this::removeTablist);
    }

    public void createTablist(Player player) {
        UUID uuid = player.getUniqueId();
        this.players.add(uuid);
        this.updateTablist(uuid);
    }

    public boolean updateTablist(UUID uuid) {
        if (!this.players.contains(uuid)) {
            return false;
        }
        Player player = Bukkit.getPlayer(uuid);
        if (player == null) {
            return false;
        }
        TablistHelper.sendTabList(player, PlaceholderUtil.setPlaceholders(this.header, player), PlaceholderUtil.setPlaceholders(this.footer, player));
        return true;
    }

    public void removeTablist(Player player) {
        if (this.players.contains(player.getUniqueId())) {
            this.players.remove(player.getUniqueId());
            TablistHelper.sendTabList(player, null, null);
        }
    }

    public List<UUID> getPlayers() {
        return this.players;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.inDisabledWorld(player.getLocation())) {
            this.createTablist(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeTablist(event.getPlayer());
    }

    @EventHandler
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().getWorld().getName().equals(event.getTo().getWorld().getName())) {
            return;
        }
        if (this.inDisabledWorld(event.getTo().getWorld()) && this.players.contains(player.getUniqueId())) {
            this.removeTablist(player);
        } else {
            this.createTablist(player);
        }
    }
}

