/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.module.modules.world;

import java.util.Arrays;
import java.util.List;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.Permissions;
import net.zithium.deluxehub.config.ConfigType;
import net.zithium.deluxehub.config.Messages;
import net.zithium.deluxehub.cooldown.CooldownType;
import net.zithium.deluxehub.libs.nbt.NBTItem;
import net.zithium.deluxehub.libs.xseries.XMaterial;
import net.zithium.deluxehub.module.Module;
import net.zithium.deluxehub.module.ModuleType;
import net.zithium.deluxehub.module.modules.hologram.Hologram;
import net.zithium.deluxehub.module.modules.world.LobbySpawn;
import net.zithium.deluxehub.utility.TeleportUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.inventory.ItemStack;

public class WorldProtect
extends Module {
    private boolean hungerLoss;
    private boolean fallDamage;
    private boolean weatherChange;
    private boolean deathMessage;
    private boolean fireSpread;
    private boolean leafDecay;
    private boolean mobSpawning;
    private boolean blockBurn;
    private boolean voidDeath;
    private boolean itemDrop;
    private boolean itemPickup;
    private boolean blockBreak;
    private boolean blockPlace;
    private boolean blockInteract;
    private boolean playerPvP;
    private boolean playerDrowning;
    private boolean fireDamage;
    private final List<Material> interactable = Arrays.asList(XMaterial.ACACIA_DOOR.parseMaterial(), XMaterial.ACACIA_FENCE_GATE.parseMaterial(), XMaterial.ANVIL.parseMaterial(), XMaterial.FLOWER_POT.parseMaterial(), XMaterial.PAINTING.parseMaterial(), XMaterial.BEACON.parseMaterial(), XMaterial.RED_BED.parseMaterial(), XMaterial.BIRCH_DOOR.parseMaterial(), XMaterial.BIRCH_FENCE_GATE.parseMaterial(), XMaterial.OAK_BOAT.parseMaterial(), XMaterial.BREWING_STAND.parseMaterial(), XMaterial.COMMAND_BLOCK.parseMaterial(), XMaterial.CHEST.parseMaterial(), XMaterial.DARK_OAK_DOOR.parseMaterial(), XMaterial.SPRUCE_DOOR.parseMaterial(), XMaterial.DARK_OAK_FENCE_GATE.parseMaterial(), XMaterial.DAYLIGHT_DETECTOR.parseMaterial(), XMaterial.DAYLIGHT_DETECTOR.parseMaterial(), XMaterial.DISPENSER.parseMaterial(), XMaterial.DROPPER.parseMaterial(), XMaterial.ENCHANTING_TABLE.parseMaterial(), XMaterial.ENDER_CHEST.parseMaterial(), XMaterial.OAK_FENCE_GATE.parseMaterial(), XMaterial.FURNACE.parseMaterial(), XMaterial.HOPPER.parseMaterial(), XMaterial.HOPPER_MINECART.parseMaterial(), XMaterial.ITEM_FRAME.parseMaterial(), XMaterial.JUNGLE_DOOR.parseMaterial(), XMaterial.JUNGLE_FENCE_GATE.parseMaterial(), XMaterial.LEVER.parseMaterial(), XMaterial.MINECART.parseMaterial(), XMaterial.NOTE_BLOCK.parseMaterial(), XMaterial.MINECART.parseMaterial(), XMaterial.COMPARATOR.parseMaterial(), XMaterial.ACACIA_SIGN.parseMaterial(), XMaterial.BIRCH_SIGN.parseMaterial(), XMaterial.DARK_OAK_SIGN.parseMaterial(), XMaterial.JUNGLE_SIGN.parseMaterial(), XMaterial.OAK_SIGN.parseMaterial(), XMaterial.CHEST_MINECART.parseMaterial(), XMaterial.OAK_DOOR.parseMaterial(), XMaterial.OAK_TRAPDOOR.parseMaterial(), XMaterial.TRAPPED_CHEST.parseMaterial(), XMaterial.OAK_BUTTON.parseMaterial(), XMaterial.OAK_DOOR.parseMaterial());

    public WorldProtect(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.WORLD_PROTECT);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.hungerLoss = config.getBoolean("world_settings.disable_hunger_loss");
        this.fallDamage = config.getBoolean("world_settings.disable_fall_damage");
        this.playerPvP = config.getBoolean("world_settings.disable_player_pvp");
        this.voidDeath = config.getBoolean("world_settings.disable_void_death");
        this.weatherChange = config.getBoolean("world_settings.disable_weather_change");
        this.deathMessage = config.getBoolean("world_settings.disable_death_message");
        this.mobSpawning = config.getBoolean("world_settings.disable_mob_spawning");
        this.itemDrop = config.getBoolean("world_settings.disable_item_drop");
        this.itemPickup = config.getBoolean("world_settings.disable_item_pickup");
        this.blockBreak = config.getBoolean("world_settings.disable_block_break");
        this.blockPlace = config.getBoolean("world_settings.disable_block_place");
        this.blockInteract = config.getBoolean("world_settings.disable_block_interact");
        this.blockBurn = config.getBoolean("world_settings.disable_block_burn");
        this.fireSpread = config.getBoolean("world_settings.disable_block_fire_spread");
        this.leafDecay = config.getBoolean("world_settings.disable_block_leaf_decay");
        this.playerDrowning = config.getBoolean("world_settings.disable_drowning");
        this.fireDamage = config.getBoolean("world_settings.disable_fire_damage");
    }

    @Override
    public void onDisable() {
    }

    @EventHandler
    public void onArmorStandInteract(PlayerArmorStandManipulateEvent event) {
        for (Hologram entry : this.getPlugin().getHologramManager().getHolograms()) {
            for (ArmorStand stand : entry.getStands()) {
                if (!stand.equals(event.getRightClicked())) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.blockBreak || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (player.hasPermission(Permissions.EVENT_BLOCK_BREAK.getPermission())) {
            return;
        }
        event.setCancelled(true);
        if (this.tryCooldown(player.getUniqueId(), CooldownType.BLOCK_BREAK, 3L)) {
            Messages.EVENT_BLOCK_BREAK.send(player, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.blockPlace || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        ItemStack item = event.getItemInHand();
        if (item.getType() == Material.AIR) {
            return;
        }
        if (new NBTItem(event.getItemInHand()).hasKey("hotbarItem").booleanValue()) {
            event.setCancelled(true);
            return;
        }
        if (player.hasPermission(Permissions.EVENT_BLOCK_PLACE.getPermission())) {
            return;
        }
        event.setCancelled(true);
        if (this.tryCooldown(event.getPlayer().getUniqueId(), CooldownType.BLOCK_PLACE, 3L)) {
            Messages.EVENT_BLOCK_PLACE.send(player, new Object[0]);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        if (!this.blockBurn) {
            return;
        }
        if (this.inDisabledWorld(event.getBlock().getLocation())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDestroy(HangingBreakByEntityEvent event) {
        if (!this.blockBreak || this.inDisabledWorld(event.getEntity().getLocation())) {
            return;
        }
        Hanging entity = event.getEntity();
        Entity player = event.getRemover();
        if (entity instanceof Painting || entity instanceof ItemFrame && player instanceof Player) {
            if (player.hasPermission(Permissions.EVENT_BLOCK_BREAK.getPermission())) {
                return;
            }
            event.setCancelled(true);
            if (this.tryCooldown(player.getUniqueId(), CooldownType.BLOCK_BREAK, 3L)) {
                Messages.EVENT_BLOCK_BREAK.send(player, new Object[0]);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        if (!this.blockInteract || this.inDisabledWorld(event.getRightClicked().getLocation())) {
            return;
        }
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (player.hasPermission(Permissions.EVENT_BLOCK_INTERACT.getPermission())) {
            return;
        }
        if (entity instanceof ItemFrame) {
            event.setCancelled(true);
            if (this.tryCooldown(player.getUniqueId(), CooldownType.BLOCK_INTERACT, 3L)) {
                Messages.EVENT_BLOCK_INTERACT.send(player, new Object[0]);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.blockInteract || this.inDisabledWorld(event.getEntity().getLocation())) {
            return;
        }
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        if (entity instanceof ItemFrame && damager instanceof Player) {
            Player player = (Player)damager;
            if (player.hasPermission(Permissions.EVENT_BLOCK_INTERACT.getPermission())) {
                return;
            }
            event.setCancelled(true);
            if (this.tryCooldown(player.getUniqueId(), CooldownType.BLOCK_INTERACT, 3L)) {
                Messages.EVENT_BLOCK_INTERACT.send(player, new Object[0]);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockInteract(PlayerInteractEvent event) {
        if (!this.blockInteract || this.inDisabledWorld(event.getPlayer().getLocation())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission(Permissions.EVENT_BLOCK_INTERACT.getPermission())) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            for (Material material : this.interactable) {
                if (block.getType() != material && !block.getType().toString().contains("POTTED")) continue;
                event.setCancelled(true);
                if (this.tryCooldown(player.getUniqueId(), CooldownType.BLOCK_INTERACT, 3L)) {
                    Messages.EVENT_BLOCK_INTERACT.send(player, new Object[0]);
                }
                return;
            }
        } else if (event.getAction() == Action.PHYSICAL && block.getType() == XMaterial.FARMLAND.parseMaterial()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (this.fallDamage && cause == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        } else if (this.playerDrowning && cause == EntityDamageEvent.DamageCause.DROWNING) {
            event.setCancelled(true);
        } else if (this.fireDamage && (cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK || cause == EntityDamageEvent.DamageCause.LAVA)) {
            event.setCancelled(true);
        } else if (this.voidDeath && cause == EntityDamageEvent.DamageCause.VOID) {
            player.setFallDistance(0.0f);
            Location location = ((LobbySpawn)this.getPlugin().getModuleManager().getModule(ModuleType.LOBBY)).getLocation();
            if (location == null) {
                return;
            }
            TeleportUtil.teleportCompatLaterAtEntity(player, location, 3L, null);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFireSpread(BlockIgniteEvent event) {
        if (!this.fireSpread) {
            return;
        }
        if (this.inDisabledWorld(event.getBlock().getLocation())) {
            return;
        }
        if (event.getCause() == BlockIgniteEvent.IgniteCause.SPREAD) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFoodChange(FoodLevelChangeEvent event) {
        if (!this.hungerLoss) {
            return;
        }
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDropEvent(PlayerDropItemEvent event) {
        if (!this.itemDrop) {
            return;
        }
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (player.hasPermission(Permissions.EVENT_ITEM_DROP.getPermission())) {
            return;
        }
        event.setCancelled(true);
        if (this.tryCooldown(player.getUniqueId(), CooldownType.ITEM_DROP, 3L)) {
            Messages.EVENT_ITEM_DROP.send(player, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        if (!this.itemPickup) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (player.hasPermission(Permissions.EVENT_ITEM_PICKUP.getPermission())) {
            return;
        }
        event.setCancelled(true);
        if (this.tryCooldown(player.getUniqueId(), CooldownType.ITEM_PICKUP, 3L)) {
            Messages.EVENT_ITEM_PICKUP.send(player, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLeafDecay(LeavesDecayEvent event) {
        if (!this.leafDecay) {
            return;
        }
        if (this.inDisabledWorld(event.getBlock().getLocation())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (!this.mobSpawning) {
            return;
        }
        if (this.inDisabledWorld(event.getEntity().getLocation())) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWeatherChange(WeatherChangeEvent event) {
        if (!this.weatherChange || this.inDisabledWorld(event.getWorld())) {
            return;
        }
        event.setCancelled(event.toWeatherState());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.deathMessage || this.inDisabledWorld(event.getEntity().getLocation())) {
            return;
        }
        event.setDeathMessage(null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (!this.playerPvP) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (event.getDamager().hasPermission(Permissions.EVENT_PLAYER_PVP.getPermission())) {
            return;
        }
        event.setCancelled(true);
        if (this.tryCooldown(player.getUniqueId(), CooldownType.PLAYER_PVP, 3L)) {
            Messages.EVENT_PLAYER_PVP.send(player, new Object[0]);
        }
    }
}

