/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.utility;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.folialib.wrapper.task.WrappedTask;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class TeleportUtil {
    private static final PlatformScheduler scheduler = DeluxeHubPlugin.scheduler();
    private static final Method TELEPORT_ASYNC;
    private static final Method TELEPORT_ASYNC_WITH_CAUSE;

    private TeleportUtil() {
    }

    public static CompletableFuture<Boolean> teleportCompat(Player player, Location location) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (player == null || location == null) {
            result.complete(false);
            return result;
        }
        scheduler.runAtEntity(player, task -> {
            try {
                if (TELEPORT_ASYNC != null) {
                    CompletableFuture cf = (CompletableFuture)TELEPORT_ASYNC.invoke((Object)player, location);
                    cf.whenComplete((ok, ex) -> result.complete(ex == null && Boolean.TRUE.equals(ok)));
                } else {
                    result.complete(player.teleport(location));
                }
            }
            catch (Throwable t) {
                result.complete(player.teleport(location));
            }
        });
        return result;
    }

    public static CompletableFuture<Boolean> teleportCompat(Player player, Location location, PlayerTeleportEvent.TeleportCause cause) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (player == null || location == null) {
            result.complete(false);
            return result;
        }
        scheduler.runAtEntity(player, task -> {
            try {
                if (TELEPORT_ASYNC_WITH_CAUSE != null) {
                    CompletableFuture cf = (CompletableFuture)TELEPORT_ASYNC_WITH_CAUSE.invoke((Object)player, new Object[]{location, cause});
                    cf.whenComplete((ok, ex) -> result.complete(ex == null && Boolean.TRUE.equals(ok)));
                } else if (TELEPORT_ASYNC != null) {
                    CompletableFuture cf = (CompletableFuture)TELEPORT_ASYNC.invoke((Object)player, location);
                    cf.whenComplete((ok, ex) -> result.complete(ex == null && Boolean.TRUE.equals(ok)));
                } else {
                    result.complete(player.teleport(location, cause));
                }
            }
            catch (Throwable t) {
                result.complete(player.teleport(location, cause));
            }
        });
        return result;
    }

    public static WrappedTask teleportCompatLaterAtEntity(Player player, Location location, long delayTicks, Runnable after) {
        return scheduler.runAtEntityLater((Entity)player, () -> TeleportUtil.teleportCompat(player, location).whenComplete((ignored, __) -> {
            if (after != null) {
                after.run();
            }
        }), delayTicks);
    }

    public static CompletableFuture<Boolean> teleportCompat(Entity entity, Location location) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (entity == null || location == null) {
            result.complete(false);
            return result;
        }
        scheduler.runAtEntity(entity, task -> result.complete(entity.teleport(location)));
        return result;
    }

    static {
        Method m1 = null;
        Method m2 = null;
        try {
            m1 = Player.class.getMethod("teleportAsync", Location.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            m2 = Player.class.getMethod("teleportAsync", Location.class, PlayerTeleportEvent.TeleportCause.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        TELEPORT_ASYNC = m1;
        TELEPORT_ASYNC_WITH_CAUSE = m2;
    }
}

