/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.utility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.Permissions;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.libs.library.utils.ColorUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final PlatformScheduler scheduler;
    private final String localPluginVersion;
    private String spigotPluginVersion;
    private static final int ID = 49425;
    private static final Permission UPDATE_PERM = new Permission(Permissions.UPDATE_NOTIFICATION.getPermission(), PermissionDefault.TRUE);
    private static final long CHECK_INTERVAL = 12000L;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.scheduler = DeluxeHubPlugin.scheduler();
        this.localPluginVersion = plugin.getDescription().getVersion();
    }

    public void checkForUpdate() {
        this.scheduler.runTimerAsync(task -> {
            try {
                URI uri = new URI("https://api.spigotmc.org/legacy/update.php?resource=49425");
                HttpsURLConnection connection = (HttpsURLConnection)uri.toURL().openConnection();
                connection.setRequestMethod("GET");
                this.spigotPluginVersion = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            }
            catch (IOException | URISyntaxException e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to check for updates from Spigot API", e);
                task.cancel();
                return;
            }
            if (this.localPluginVersion.equals(this.spigotPluginVersion)) {
                return;
            }
            this.plugin.getLogger().info("An update for DeluxeHub (v%VERSION%) is available at:".replace("%VERSION%", this.spigotPluginVersion));
            this.plugin.getLogger().info("https://www.spigotmc.org/resources/49425");
            this.scheduler.runNextTick(nextTask -> Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                public void onPlayerJoin(PlayerJoinEvent event) {
                    Player player = event.getPlayer();
                    if (!player.hasPermission(UPDATE_PERM)) {
                        return;
                    }
                    player.sendMessage(ColorUtil.color("&7An update (v%VERSION%) for DeluxeHub is available at:".replace("%VERSION%", UpdateChecker.this.spigotPluginVersion)));
                    player.sendMessage(ColorUtil.color("&6https://www.spigotmc.org/resources/49425"));
                }
            }, this.plugin));
            task.cancel();
        }, 1L, 12000L);
    }
}

