/*
 * Decompiled with CFR 0.152.
 */
package net.zithium.deluxehub.utility.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import net.zithium.deluxehub.DeluxeHubPlugin;
import net.zithium.deluxehub.libs.folialib.impl.PlatformScheduler;
import net.zithium.deluxehub.utility.reflection.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ActionBar {
    private static final JavaPlugin PLUGIN = JavaPlugin.getProvidingPlugin(DeluxeHubPlugin.class);
    private static final PlatformScheduler SCHEDULER = DeluxeHubPlugin.scheduler();
    private static final MethodHandle CHAT_COMPONENT_TEXT;
    private static final MethodHandle PACKET;
    private static final Object CHAT_MESSAGE_TYPE;

    public static void sendActionBar(Player player, String message) {
        Objects.requireNonNull(player, "Cannot send action bar to null player");
        Object packet = null;
        try {
            Object component = CHAT_COMPONENT_TEXT.invoke(message);
            packet = PACKET.invoke(component, CHAT_MESSAGE_TYPE);
        }
        catch (Throwable throwable) {
            PLUGIN.getLogger().log(Level.SEVERE, "Failed to create action bar packet for player " + player.getName(), throwable);
        }
        ReflectionUtils.sendPacket(player, packet);
    }

    public static void sendAllActionBar(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.sendActionBar(player, message);
        }
    }

    public static void sendActionBarWhile(Player player, String message, Callable<Boolean> callable) {
        SCHEDULER.runTimerAsync(task -> {
            try {
                if (!((Boolean)callable.call()).booleanValue()) {
                    task.cancel();
                    return;
                }
            }
            catch (Exception ex) {
                PLUGIN.getLogger().log(Level.SEVERE, "Error in action bar callable for player " + player.getName(), ex);
                task.cancel();
                return;
            }
            ActionBar.sendActionBar(player, message);
        }, 1L, 40L);
    }

    public static void sendActionBarWhile(Player player, Callable<String> message, Callable<Boolean> callable) {
        SCHEDULER.runTimerAsync(task -> {
            try {
                if (!((Boolean)callable.call()).booleanValue()) {
                    task.cancel();
                    return;
                }
                ActionBar.sendActionBar(player, (String)message.call());
            }
            catch (Exception ex) {
                PLUGIN.getLogger().log(Level.SEVERE, "Error in action bar callable for player " + player.getName(), ex);
                task.cancel();
            }
        }, 1L, 40L);
    }

    public static void sendActionBar(Player player, String message, long duration) {
        if (duration < 1L) {
            return;
        }
        AtomicLong repeater = new AtomicLong(duration);
        SCHEDULER.runTimerAsync(task -> {
            ActionBar.sendActionBar(player, message);
            repeater.addAndGet(-40L);
            if (repeater.get() - 40L < -20L) {
                task.cancel();
            }
        }, 1L, 40L);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> packetPlayOutChatClass = ReflectionUtils.getNMSClass("PacketPlayOutChat");
        Class<?> iChatBaseComponentClass = ReflectionUtils.getNMSClass("IChatBaseComponent");
        MethodHandle packet = null;
        MethodHandle chatComp = null;
        Byte chatMsgType = null;
        try {
            Class<?> chatMessageTypeClass = Class.forName("net.minecraft.server." + ReflectionUtils.VERSION + ".ChatMessageType");
            for (Object obj : chatMessageTypeClass.getEnumConstants()) {
                if (!obj.toString().equals("GAME_INFO")) continue;
                chatMsgType = obj;
                break;
            }
            Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("ChatComponentText");
            assert (chatComponentTextClass != null);
            chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
            assert (packetPlayOutChatClass != null);
            packet = lookup.findConstructor(packetPlayOutChatClass, MethodType.methodType(Void.TYPE, iChatBaseComponentClass, chatMessageTypeClass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
            try {
                chatMsgType = 2;
                Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("ChatComponentText");
                assert (chatComponentTextClass != null);
                chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
                assert (packetPlayOutChatClass != null);
                packet = lookup.findConstructor(packetPlayOutChatClass, MethodType.methodType(Void.TYPE, iChatBaseComponentClass, Byte.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                PLUGIN.getLogger().log(Level.SEVERE, "Failed to initialize ActionBar packet constructors", ex);
            }
        }
        CHAT_MESSAGE_TYPE = chatMsgType;
        CHAT_COMPONENT_TEXT = chatComp;
        PACKET = packet;
    }
}

