/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.action;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.action.Action;
import fun.lewisdev.deluxehub.action.actions.ActionbarAction;
import fun.lewisdev.deluxehub.action.actions.BroadcastMessageAction;
import fun.lewisdev.deluxehub.action.actions.BungeeAction;
import fun.lewisdev.deluxehub.action.actions.CloseInventoryAction;
import fun.lewisdev.deluxehub.action.actions.CommandAction;
import fun.lewisdev.deluxehub.action.actions.ConsoleCommandAction;
import fun.lewisdev.deluxehub.action.actions.GamemodeAction;
import fun.lewisdev.deluxehub.action.actions.MenuAction;
import fun.lewisdev.deluxehub.action.actions.MessageAction;
import fun.lewisdev.deluxehub.action.actions.PotionEffectAction;
import fun.lewisdev.deluxehub.action.actions.SoundAction;
import fun.lewisdev.deluxehub.action.actions.TitleAction;
import fun.lewisdev.deluxehub.utility.PlaceholderUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class ActionManager {
    private final DeluxeHubPlugin plugin;
    private final Map<String, Action> actions;

    public ActionManager(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
        this.actions = new HashMap<String, Action>();
        this.load();
    }

    private void load() {
        this.registerAction(new MessageAction(), new BroadcastMessageAction(), new CommandAction(), new ConsoleCommandAction(), new SoundAction(), new PotionEffectAction(), new GamemodeAction(), new BungeeAction(), new CloseInventoryAction(), new ActionbarAction(), new TitleAction(), new MenuAction());
    }

    public void registerAction(Action ... actions) {
        Arrays.asList(actions).forEach(action -> this.actions.put(action.getIdentifier(), (Action)action));
    }

    public void executeActions(Player player, List<String> items) {
        items.forEach(item -> {
            Action action;
            String actionName = StringUtils.substringBetween(item, "[", "]");
            Action action2 = action = actionName == null ? null : this.actions.get(actionName.toUpperCase());
            if (action != null) {
                item = item.contains(" ") ? item.split(" ", 2)[1] : "";
                item = PlaceholderUtil.setPlaceholders(item, player);
                action.execute(this.plugin, player, (String)item);
            } else {
                this.plugin.getLogger().warning("There was a problem attempting to process action: '" + item + "'");
            }
        });
    }
}

