/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.cooldown;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import fun.lewisdev.deluxehub.cooldown.CooldownType;
import java.util.UUID;

public class CooldownManager {
    private Table<String, CooldownType, Long> cooldowns = HashBasedTable.create();

    public long getCooldown(UUID uuid, CooldownType key) {
        return this.calculateRemainder(this.cooldowns.get(uuid.toString(), (Object)key));
    }

    public long setCooldown(UUID uuid, CooldownType key, long delay) {
        return this.calculateRemainder(this.cooldowns.put(uuid.toString(), key, System.currentTimeMillis() + delay * 1000L));
    }

    public boolean tryCooldown(UUID uuid, CooldownType key, long delay) {
        if (this.getCooldown(uuid, key) / 1000L > 0L) {
            return false;
        }
        this.setCooldown(uuid, key, delay + 1L);
        return true;
    }

    public void removeCooldowns(UUID uuid) {
        this.cooldowns.row(uuid.toString()).clear();
    }

    private long calculateRemainder(Long expireTime) {
        return expireTime != null ? expireTime - System.currentTimeMillis() : Long.MIN_VALUE;
    }
}

